/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system.bubblechart;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.gadgets.system.bubblechart.IssueBubbleData;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ToIssueBubbleData
implements Function<Issue, IssueBubbleData> {
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final String PARTICIPANTS = "participants";
    private static final String VOTES = "votes";
    private final CommentService commentService;
    private final ApplicationUser user;
    private final String bubbleType;
    private final long now = System.currentTimeMillis();
    private final long recentCommentPeriodStart;

    public ToIssueBubbleData(CommentService commentService, ApplicationUser user, String bubbleType, int recentCommentsDays) {
        this.commentService = commentService;
        this.user = user;
        this.bubbleType = bubbleType;
        this.recentCommentPeriodStart = this.now - (long)recentCommentsDays * ONE_DAY;
    }

    @Override
    public IssueBubbleData apply(Issue issue) {
        List commentsForUser = this.commentService.getCommentsForUser(this.user, issue);
        Set<Long> participants = this.getParticipantsForIssue(issue);
        Set<Long> commenters = this.getCommentersForComments(commentsForUser);
        participants.addAll(commenters);
        long recentCommentCount = this.getRecentCommentCount(commentsForUser, this.recentCommentPeriodStart);
        int daysCreatedAgo = (int)((this.now - issue.getCreated().getTime()) / ONE_DAY);
        int bubbleRadius = 0;
        if (this.bubbleType.equals(PARTICIPANTS)) {
            bubbleRadius = participants.size();
        } else if (this.bubbleType.equals(VOTES)) {
            bubbleRadius = issue.getVotes().intValue();
        }
        return new IssueBubbleData(issue.getKey(), daysCreatedAgo, commentsForUser.size(), bubbleRadius, recentCommentCount);
    }

    private Set<Long> getParticipantsForIssue(Issue issue) {
        HashSet participants = Sets.newHashSet();
        if (issue.getReporter() != null) {
            participants.add(issue.getReporter().getId());
        }
        if (issue.getAssignee() != null) {
            participants.add(issue.getAssignee().getId());
        }
        return participants;
    }

    private Set<Long> getCommentersForComments(Collection<Comment> comments) {
        return comments.stream().map(comment -> comment.getAuthorApplicationUser().getId()).collect(Collectors.toSet());
    }

    private long getRecentCommentCount(List<Comment> commentsForUser, long recentCommentPeriodStart) {
        return commentsForUser.stream().filter(comment -> comment.getCreated().getTime() > recentCommentPeriodStart).count();
    }
}

