/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system.bubblechart;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.bubblechart.IssueBubbleData;
import com.atlassian.jira.gadgets.system.bubblechart.ToIssueBubbleData;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@Path(value="/bubblechart")
@Produces(value={"application/json"})
@AnonymousAllowed
public class BubbleChartResource
extends SearchQueryBackedResource {
    private static final int MAX_ISSUES = 200;
    private static final String BUBBLE_TYPE = "bubbleType";
    private static final String RECENT_COMMENTS_PERIOD = "recentCommentsPeriod";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CommentService commentService;

    public BubbleChartResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport CommentService commentService) {
        super(chartUtils, jiraAuthenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.commentService = commentService;
    }

    @GET
    @Path(value="/generate")
    @Produces(value={"application/json"})
    public Response generateChart(@QueryParam(value="projectOrFilterId") String projectOrFilterId, @QueryParam(value="bubbleType") @DefaultValue(value="participants") String bubbleType, @QueryParam(value="recentCommentsPeriod") @DefaultValue(value="1") int recentCommentsDays) {
        SearchResults search;
        if (StringUtils.isNotBlank((String)projectOrFilterId) && !projectOrFilterId.contains("-")) {
            projectOrFilterId = "filter-" + projectOrFilterId;
        }
        HashMap params = Maps.newHashMap();
        ArrayList errors = Lists.newArrayList();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(projectOrFilterId, errors, params);
        if (!errors.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.toErrorCollection(errors)).build();
        }
        try {
            search = this.searchService.search(this.jiraAuthenticationContext.getLoggedInUser(), searchRequest.getQuery(), new PagerFilter(200));
        }
        catch (SearchException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        int issueCount = search.getTotal();
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        String warning = issueCount > 200 ? i18n.getText("bubble-charts.exceed.issues", Integer.toString(issueCount), Integer.toString(200)) : null;
        List data = (List)search.getIssues().stream().map(new ToIssueBubbleData(this.commentService, this.jiraAuthenticationContext.getLoggedInUser(), bubbleType, recentCommentsDays)).collect(CollectorsUtil.toImmutableList());
        String filterTitle = i18n.getText(this.getFilterTitle(params));
        return Response.ok((Object)new ResponseContainer(warning, data, filterTitle, issueCount)).build();
    }

    private ErrorCollection toErrorCollection(List<ValidationError> errors) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errors.forEach(arg_0 -> BubbleChartResource.lambda$toErrorCollection$0((com.atlassian.jira.util.ErrorCollection)errorCollection, i18n, arg_0));
        return ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private static /* synthetic */ void lambda$toErrorCollection$0(com.atlassian.jira.util.ErrorCollection errorCollection, I18nHelper i18n, ValidationError error) {
        errorCollection.addError(error.getField(), i18n.getText(error.getError()));
    }

    @XmlRootElement
    public static class ResponseContainer {
        @XmlElement
        private final String warning;
        @XmlElement
        private final int issueCount;
        @XmlElement
        private final String filterTitle;
        @XmlElement
        private final List<IssueBubbleData> data;

        public ResponseContainer(String warning, List<IssueBubbleData> issueData, String filterTitle, int issueCount) {
            this.warning = warning;
            this.issueCount = issueCount;
            this.filterTitle = filterTitle;
            this.data = issueData;
        }

        public String getWarning() {
            return this.warning;
        }

        public int getIssueCount() {
            return this.issueCount;
        }

        public String getFilterTitle() {
            return this.filterTitle;
        }

        public List<IssueBubbleData> getData() {
            return this.data;
        }
    }
}

