/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.util.ResourceDateValidator;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/timeSince")
@AnonymousAllowed
@Produces(value={"application/json"})
public class TimeSinceChartResource
extends SearchQueryBackedResource {
    static final String PERIOD_NAME = "periodName";
    static final String DAYS = "daysprevious";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String NUM_ISSUES = "numIssues";
    private static final String DATE_FIELD = "dateField";
    private static final String IS_CUMULATIVE = "isCumulative";
    private static final String INLINE = "inline";
    private final ChartFactory chartFactory;
    private final FieldManager fieldManager;
    private ResourceDateValidator resourceDateValidator;

    public TimeSinceChartResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, @ComponentImport ChartFactory chartFactory, @ComponentImport FieldManager fieldManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties) {
        this(chartUtils, authenticationContext, searchService, permissionManager, chartFactory, fieldManager, new ResourceDateValidator(applicationProperties), velocityRequestContextFactory);
    }

    public TimeSinceChartResource(ChartUtils chartUtils, JiraAuthenticationContext authenticationContext, SearchService searchService, PermissionManager permissionManager, ChartFactory chartFactory, FieldManager fieldManager, ResourceDateValidator resourceDateValidator, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.fieldManager = fieldManager;
        this.resourceDateValidator = resourceDateValidator;
    }

    @GET
    @Path(value="/generate")
    public Response generateChart(@Context HttpServletRequest request, @QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="dateField") @DefaultValue(value="created") String dateField, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="isCumulative") @DefaultValue(value="true") boolean isCumulative, @QueryParam(value="width") @DefaultValue(value="450") int width, @QueryParam(value="height") @DefaultValue(value="300") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        int validatedDays = this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        Field field = this.validateDateField(dateField, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        try {
            Chart chart = this.chartFactory.generateTimeSinceChart(context, validatedDays, period, isCumulative, field.getId());
            String location = chart.getLocation();
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            Integer issueCount = (Integer)chart.getParameters().get(NUM_ISSUES);
            String imageMap = chart.getImageMap();
            String imageMapName = chart.getImageMapName();
            String chartFilterUrl = (String)chart.getParameters().get("chartFilterUrl");
            boolean isProject = params.containsKey("project");
            TimeSinceChart timeSinceChart = new TimeSinceChart(location, title, filterUrl, imageMap, imageMapName, issueCount, field.getName(), width, height, chartFilterUrl, isProject, chart.getBase64Image());
            return Response.ok((Object)timeSinceChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    Field validateDateField(String fieldId, Collection<ValidationError> errors) {
        Field field = this.fieldManager.getField(fieldId);
        if (field == null) {
            ValidationError error = new ValidationError(DAYS, "gadget.time.since.invalid.date.field", fieldId);
            errors.add(error);
        } else if (!this.isDateTypeField(field)) {
            List<String> params = Arrays.asList(fieldId, field.getName());
            ValidationError error = new ValidationError(DAYS, "gadget.time.since.not.date.field", params);
            errors.add(error);
        }
        return field;
    }

    boolean isDateTypeField(Field field) {
        if (this.fieldManager.isCustomField(field)) {
            CustomFieldType customFieldType = ((CustomField)field).getCustomFieldType();
            return customFieldType instanceof DateField;
        }
        return field instanceof DateField;
    }

    @GET
    @Path(value="/validate")
    public Response validateChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="dateField") @DefaultValue(value="created") String dateField, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, errors, new HashMap<String, Object>());
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        this.resourceDateValidator.validateDaysPrevious(DAYS, period, days, errors);
        this.validateDateField(dateField, errors);
        return this.createValidationResponse(errors);
    }

    @XmlRootElement
    public static class TimeSinceChart {
        @XmlElement
        private String chartFilterUrl;
        @XmlElement
        private boolean isProject;
        @XmlElement
        private String location;
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private String imageMap;
        @XmlElement
        private String imageMapName;
        @XmlElement
        private Integer issueCount;
        @XmlElement
        private String fieldName;
        @XmlElement
        private int width;
        @XmlElement
        private int height;
        @XmlElement
        private String base64Image;

        private TimeSinceChart() {
        }

        TimeSinceChart(String location, String filterTitle, String filterUrl, String imageMap, String imageMapName, Integer issueCount, String fieldName, int width, int height, String chartFilterUrl, boolean isProject, String base64Image) {
            this.location = location;
            this.filterTitle = filterTitle;
            this.filterUrl = filterUrl;
            this.imageMap = imageMap;
            this.imageMapName = imageMapName;
            this.issueCount = issueCount;
            this.fieldName = fieldName;
            this.width = width;
            this.height = height;
            this.chartFilterUrl = chartFilterUrl;
            this.isProject = isProject;
            this.base64Image = base64Image;
        }
    }
}

