/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.charts.jfreechart.TimePeriodUtils;
import com.atlassian.jira.gadgets.system.DateRangeChart;
import com.atlassian.jira.timezone.TimeZoneManager;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

@XmlRootElement
public class TimeChart
extends DateRangeChart {
    @XmlElement
    private TimeDataRow[] data;

    private TimeChart() {
    }

    public TimeChart(String location, String title, String filterUrl, String imageMap, String imageMapName, TimeDataRow[] data, int width, int height, String base64Image) {
        super(location, title, filterUrl, imageMap, imageMapName, width, height, base64Image);
        this.data = data;
    }

    TimeDataRow[] getData() {
        return this.data;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @XmlRootElement
    public static class TimeDataRow {
        @XmlElement
        private String period;
        @XmlElement
        private int issues;
        @XmlElement
        private String issuesLink;
        @XmlElement
        private int totalTime;
        @XmlElement
        private int avgTime;

        private TimeDataRow() {
        }

        public TimeDataRow(String period, int issues, String issuesLink, int totalTime, int avgTime) {
            this.period = period;
            this.issues = issues;
            this.issuesLink = issuesLink;
            this.totalTime = totalTime;
            this.avgTime = avgTime;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class Generator {
        TimeDataRow[] generateDataSet(TimeSeriesCollection dataSet, XYURLGenerator urlGenerator, TimeZoneManager timeZoneManager) {
            TimePeriodUtils timePeriodUtils = new TimePeriodUtils(timeZoneManager);
            TimeSeries issuesSeries = dataSet.getSeries(0);
            TimeSeries totalSeries = dataSet.getSeries(1);
            TimeSeries averageSeries = dataSet.getSeries(2);
            int count = issuesSeries.getItems().size();
            ArrayList<TimeDataRow> data = new ArrayList<TimeDataRow>(count);
            for (int i = 0; i < count; ++i) {
                int issues = issuesSeries.getValue(i).intValue();
                int total = totalSeries.getValue(i).intValue();
                int avg = averageSeries.getValue(i).intValue();
                String issuesLink = urlGenerator != null ? urlGenerator.generateURL((XYDataset)dataSet, 0, i) : null;
                RegularTimePeriod timePeriod = issuesSeries.getTimePeriod(i);
                data.add(new TimeDataRow(timePeriodUtils.prettyPrint((TimePeriod)timePeriod), issues, issuesLink, total, avg));
            }
            return data.toArray(new TimeDataRow[data.size()]);
        }
    }
}

