/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.issue.statistics.ComponentStatisticsMapper;
import com.atlassian.jira.issue.statistics.CreatorStatisticsMapper;
import com.atlassian.jira.issue.statistics.FixForVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.IssueTypeStatisticsMapper;
import com.atlassian.jira.issue.statistics.LabelsStatisticsMapper;
import com.atlassian.jira.issue.statistics.PriorityStatisticsMapper;
import com.atlassian.jira.issue.statistics.ProjectStatisticsMapper;
import com.atlassian.jira.issue.statistics.RaisedInVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.ReporterStatisticsMapper;
import com.atlassian.jira.issue.statistics.ResolutionStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.StatusStatisticsMapper;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class SystemStatisticTypesFactory {
    static final String COMPONENTS = "components";
    static final String FIXFOR = "fixfor";
    static final String ALLFIXFOR = "allFixfor";
    static final String VERSION = "version";
    static final String ALLVERSION = "allVersion";
    static final String ASSIGNEES = "assignees";
    static final String ISSUETYPE = "issuetype";
    static final String PRIORITIES = "priorities";
    static final String PROJECT = "project";
    static final String REPORTER = "reporter";
    static final String CREATOR = "creator";
    static final String RESOLUTION = "resolution";
    static final String STATUSES = "statuses";
    static final String LABELS = "labels";
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ConstantsManager constantsManager;
    private final VersionManager versionManager;
    private final ProjectManager projectManager;

    @Autowired
    SystemStatisticTypesFactory(@ComponentImport UserManager userManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ConstantsManager constantsManager, @ComponentImport VersionManager versionManager, @ComponentImport ProjectManager projectManager) {
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.constantsManager = constantsManager;
        this.versionManager = versionManager;
        this.projectManager = projectManager;
    }

    Optional<StatisticsMapper> getSystemMapper(String statsMapperKey) {
        switch (statsMapperKey) {
            case "components": {
                return Optional.of(new ComponentStatisticsMapper());
            }
            case "assignees": {
                return Optional.of(new AssigneeStatisticsMapper(this.userManager, this.jiraAuthenticationContext));
            }
            case "issuetype": {
                return Optional.of(new IssueTypeStatisticsMapper(this.constantsManager));
            }
            case "fixfor": {
                return Optional.of(new FixForVersionStatisticsMapper(this.versionManager, false));
            }
            case "allFixfor": {
                return Optional.of(new FixForVersionStatisticsMapper(this.versionManager, true));
            }
            case "priorities": {
                return Optional.of(new PriorityStatisticsMapper(this.constantsManager));
            }
            case "project": {
                return Optional.of(new ProjectStatisticsMapper(this.projectManager));
            }
            case "version": {
                return Optional.of(new RaisedInVersionStatisticsMapper(this.versionManager, false));
            }
            case "allVersion": {
                return Optional.of(new RaisedInVersionStatisticsMapper(this.versionManager, true));
            }
            case "reporter": {
                return Optional.of(new ReporterStatisticsMapper(this.userManager, this.jiraAuthenticationContext));
            }
            case "creator": {
                return Optional.of(new CreatorStatisticsMapper(this.userManager, this.jiraAuthenticationContext));
            }
            case "resolution": {
                return Optional.of(new ResolutionStatisticsMapper(this.constantsManager));
            }
            case "statuses": {
                return Optional.of(new StatusStatisticsMapper(this.constantsManager));
            }
            case "labels": {
                return Optional.of(new LabelsStatisticsMapper(false));
            }
        }
        return Optional.empty();
    }
}

