/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/statTypes")
@AnonymousAllowed
@Produces(value={"application/json"})
public class StatisticTypesResource {
    private final CustomFieldManager customFieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final StatisticTypesProvider statisticTypesProvider;

    public StatisticTypesResource(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, StatisticTypesProvider statisticTypesProvider) {
        this.customFieldManager = customFieldManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.statisticTypesProvider = statisticTypesProvider;
    }

    @GET
    public Response getAxes() {
        Map<String, String> statisticTypes = this.getStatisticTypes();
        return Response.ok((Object)new StatTypeCollection(statisticTypes)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Map<String, String> getStatisticTypes() {
        Map<String, String> systemStatisticTypes = this.statisticTypesProvider.getSystemStatisticTypes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::translateValue));
        HashSet visibleProjects = new HashSet(this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getLoggedInUser()));
        Map<String, String> customFieldStatisticTypes = this.customFieldManager.getCustomFieldObjects().stream().filter(this::isCustomFieldStattable).filter(cf -> this.hasCustomFieldAccess((CustomField)cf, visibleProjects)).collect(Collectors.toMap(RenderableField::getId, this::translate));
        return ImmutableMap.builder().putAll(systemStatisticTypes).putAll(customFieldStatisticTypes).build();
    }

    private String translateValue(Map.Entry<?, String> entry) {
        return this.translate(entry.getValue());
    }

    private String translate(CustomField customField) {
        return this.translate(customField.getName());
    }

    private String translate(String key) {
        return this.authenticationContext.getI18nHelper().getText(key);
    }

    private boolean hasCustomFieldAccess(CustomField customField, Set<Project> visibleProjects) {
        if (customField.isAllProjects()) {
            return !visibleProjects.isEmpty();
        }
        return !Collections.disjoint(customField.getAssociatedProjectObjects(), visibleProjects);
    }

    private boolean isCustomFieldStattable(CustomField customField) {
        return customField.getCustomFieldSearcher() instanceof CustomFieldStattable;
    }

    @XmlRootElement
    public static class MapEntry {
        @XmlElement
        private final String value;
        @XmlElement
        private final String label;

        private MapEntry() {
            this.value = null;
            this.label = null;
        }

        public static MapEntry fromJavaMapEntry(Map.Entry<String, String> entry) {
            return new MapEntry(entry.getKey(), entry.getValue());
        }

        private MapEntry(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getKey() {
            return this.value;
        }

        public String getValue() {
            return this.label;
        }
    }

    @XmlRootElement
    public static class StatTypeCollection {
        @XmlElement
        private Collection<MapEntry> stats;

        private StatTypeCollection() {
        }

        public StatTypeCollection(Map<String, String> values) {
            this.stats = this.convertToMapEntryCollection(values);
        }

        public Collection<MapEntry> getValues() {
            return this.stats;
        }

        private Collection<MapEntry> convertToMapEntryCollection(Map<String, String> values) {
            return values.entrySet().stream().map(MapEntry::fromJavaMapEntry).collect(Collectors.toList());
        }
    }
}

