/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.gadgets.system.SystemStatisticTypesFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticTypesProvider {
    public static final String COMPONENTS = StatisticTypesProvider.getString("components");
    public static final String FIXFOR = StatisticTypesProvider.getString("fixfor");
    public static final String ALLFIXFOR = StatisticTypesProvider.getString("allFixfor");
    public static final String VERSION = StatisticTypesProvider.getString("version");
    public static final String ALLVERSION = StatisticTypesProvider.getString("allVersion");
    public static final String ASSIGNEES = StatisticTypesProvider.getString("assignees");
    public static final String ISSUETYPE = StatisticTypesProvider.getString("issuetype");
    public static final String PRIORITIES = StatisticTypesProvider.getString("priorities");
    public static final String PROJECT = StatisticTypesProvider.getString("project");
    public static final String REPORTER = StatisticTypesProvider.getString("reporter");
    public static final String CREATOR = StatisticTypesProvider.getString("creator");
    public static final String RESOLUTION = StatisticTypesProvider.getString("resolution");
    public static final String STATUSES = StatisticTypesProvider.getString("statuses");
    public static final String LABELS = StatisticTypesProvider.getString("labels");
    private static final Map<String, String> systemValues = ImmutableMap.builder().put((Object)ASSIGNEES, (Object)"gadget.filterstats.field.statistictype.assignees").put((Object)COMPONENTS, (Object)"gadget.filterstats.field.statistictype.components").put((Object)ISSUETYPE, (Object)"gadget.filterstats.field.statistictype.issuetype").put((Object)FIXFOR, (Object)"gadget.filterstats.field.statistictype.fixfor").put((Object)ALLFIXFOR, (Object)"gadget.filterstats.field.statistictype.allfixfor").put((Object)PRIORITIES, (Object)"gadget.filterstats.field.statistictype.priorities").put((Object)PROJECT, (Object)"gadget.filterstats.field.statistictype.project").put((Object)VERSION, (Object)"gadget.filterstats.field.statistictype.version").put((Object)ALLVERSION, (Object)"gadget.filterstats.field.statistictype.allversion").put((Object)REPORTER, (Object)"gadget.filterstats.field.statistictype.reporter").put((Object)CREATOR, (Object)"gadget.filterstats.field.statistictype.creator").put((Object)RESOLUTION, (Object)"gadget.filterstats.field.statistictype.resolution").put((Object)STATUSES, (Object)"gadget.filterstats.field.statistictype.statuses").put((Object)LABELS, (Object)"gadget.filterstats.field.statistictype.labels").build();
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldManager customFieldManager;
    private final SystemStatisticTypesFactory systemStatisticTypesFactory;

    @Autowired
    public StatisticTypesProvider(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport CustomFieldManager customFieldManager, SystemStatisticTypesFactory systemStatisticTypesFactory) {
        this.authenticationContext = authenticationContext;
        this.customFieldManager = customFieldManager;
        this.systemStatisticTypesFactory = systemStatisticTypesFactory;
    }

    private static String getString(String str) {
        return str;
    }

    public StatisticsMapper getStatsMapper(String statsMapperKey) {
        return this.getSystemMapper(statsMapperKey).orElseGet(() -> this.getCustomFieldMapper(statsMapperKey).orElse(null));
    }

    private Optional<StatisticsMapper> getSystemMapper(String statsMapperKey) {
        return this.systemStatisticTypesFactory.getSystemMapper(statsMapperKey);
    }

    private Optional<StatisticsMapper> getCustomFieldMapper(String statsMapperKey) {
        CustomField customField = this.getCustomField(statsMapperKey).orElseThrow(() -> new RuntimeException("No custom field with id " + statsMapperKey));
        if (customField.getCustomFieldSearcher() instanceof CustomFieldStattable) {
            CustomFieldStattable customFieldStattable = (CustomFieldStattable)customField.getCustomFieldSearcher();
            return Optional.of(customFieldStattable.getStatisticsMapper(customField));
        }
        return Optional.empty();
    }

    private Optional<CustomField> getCustomField(String statsMapperKey) {
        return Optional.ofNullable(this.customFieldManager.getCustomFieldObject(statsMapperKey));
    }

    public Map<String, String> getSystemStatisticTypes() {
        return systemValues;
    }

    public String getDisplayName(String field) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.getSystemStatisticType(field).map(arg_0 -> ((I18nHelper)i18n).getText(arg_0)).orElseGet(() -> this.getCustomField(field).map(Field::getName).orElse(""));
    }

    private Optional<String> getSystemStatisticType(String field) {
        return Optional.ofNullable(systemValues.get(field));
    }
}

