/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.dashboarditem.quicklinks.LinkLists;
import com.atlassian.jira.dashboarditem.quicklinks.QuickLinksProvider;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/quicklinks")
@AnonymousAllowed
@Produces(value={"application/json"})
public class QuickLinksResource {
    private final QuickLinksProvider quicklinksProvider;

    public QuickLinksResource(QuickLinksProvider quicklinksProvider) {
        this.quicklinksProvider = quicklinksProvider;
    }

    @GET
    public Response getQuickLinks() throws Exception {
        LinkLists links = this.quicklinksProvider.getLinks();
        if (links.getCommonLinks().isEmpty() && links.getNavigationLinks().isEmpty()) {
            return Response.ok((Object)new Warning()).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)links).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class Warning {
        @XmlElement
        private boolean noDataAndNoUser = true;

        private Warning() {
        }

        public boolean isNoDataNoUser() {
            return this.noDataAndNoUser;
        }
    }
}

