/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.gadgets.system.AbstractResource;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.ProjectHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/project")
@AnonymousAllowed
@Produces(value={"application/json"})
public class ProjectGadgetResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(ProjectGadgetResource.class);
    private static final String PROJECT_OR_CATEGORY_IDS = "projectsOrCategories";
    private final ProjectManager projectManager;
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private final SearchService searchService;
    private final SimpleLinkManager simpleLinkManager;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final FieldVisibilityManager fieldVisibilityManager;

    public ProjectGadgetResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ConstantsManager constantsManager, @ComponentImport SearchService searchService, @ComponentImport SimpleLinkManager simpleLinkManager, @ComponentImport ProjectDescriptionRenderer projectDescriptionRenderer, @ComponentImport FieldVisibilityManager fieldVisibilityManager) {
        this.projectManager = projectManager;
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.searchService = searchService;
        this.simpleLinkManager = simpleLinkManager;
        this.projectDescriptionRenderer = projectDescriptionRenderer;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @GET
    @Path(value="validate")
    public Response validate(@QueryParam(value="projectsOrCategories") String projectsOrCategories) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateProjectsAndCategories(errors, projectsOrCategories, true);
        return this.createValidationResponse(errors);
    }

    private void validateProjectsAndCategories(Collection<ValidationError> errors, String projectsOrCategories, boolean validatePermission) {
        if (StringUtils.isBlank((String)projectsOrCategories)) {
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.projects.and.categories.none.selected"));
            return;
        }
        List<String> projectAndCategoryIds = this.splitProjectAndCategoryIds(projectsOrCategories);
        if (projectAndCategoryIds.contains("allprojects")) {
            if (projectAndCategoryIds.size() > 1) {
                errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.all.projects.and.others"));
            }
        } else if (projectAndCategoryIds.contains("catallCategories")) {
            if (projectAndCategoryIds.size() > 1) {
                errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.all.categories.and.others"));
            }
        } else {
            boolean hasProject = false;
            boolean hasCategories = false;
            for (String projectAndCategoryId : projectAndCategoryIds) {
                if (projectAndCategoryId.startsWith("cat")) {
                    hasCategories = true;
                    continue;
                }
                hasProject = true;
            }
            if (hasCategories && hasProject) {
                errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.projects.and.categories.mixed"));
            } else if (validatePermission) {
                if (hasCategories) {
                    this.validateCategories(errors, projectAndCategoryIds);
                } else if (hasProject) {
                    this.validateProjects(errors, projectAndCategoryIds);
                } else {
                    errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.projects.and.categories.none.selected"));
                }
            }
        }
    }

    private void validateProjects(Collection<ValidationError> errors, List<String> projectAndCategoryIds) {
        for (String projectIdStr : projectAndCategoryIds) {
            this.validateProject(errors, projectIdStr);
        }
    }

    private Project validateProject(Collection<ValidationError> errors, String projectIdStr) {
        try {
            Long projectId = Long.valueOf(projectIdStr);
            Project projectObj = this.projectManager.getProjectObj(projectId);
            if (projectObj == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, projectObj, this.authenticationContext.getUser())) {
                errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.invalid.project"));
            }
            if (errors.isEmpty()) {
                return projectObj;
            }
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.invalid.project"));
        }
        return null;
    }

    private void validateCategories(Collection<ValidationError> errors, List<String> projectAndCategoryIds) {
        for (String projectId : projectAndCategoryIds) {
            ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(Long.valueOf(projectId.substring(3)));
            if (projectCategory != null && !this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getUser(), projectCategory).isEmpty()) continue;
            errors.add(new ValidationError(PROJECT_OR_CATEGORY_IDS, "gadget.common.invalid.projectCategory"));
        }
    }

    @GET
    @Path(value="filters")
    public Response getFilters(@QueryParam(value="projectId") String projectId) {
        ApplicationUser user = this.authenticationContext.getUser();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Project project = this.validateProject(errors, projectId);
        List<OptionData> list = this.getFilterData(project, user);
        return Response.ok((Object)new OptionDataList(list)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="reports")
    public Response getReports(@QueryParam(value="projectId") String projectId) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Project project = this.validateProject(errors, projectId);
        List<OptionData> list = this.getReportData(project);
        return Response.ok((Object)new OptionDataList(list)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="generate")
    public Response generate(@QueryParam(value="projectsOrCategories") String projectsOrCategories, @QueryParam(value="showStats") @DefaultValue(value="false") boolean showStats) {
        ApplicationUser user = this.authenticationContext.getUser();
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext((String)"", null);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateProjectsAndCategories(errors, projectsOrCategories, false);
        if (!errors.isEmpty()) {
            return this.createValidationResponse(errors);
        }
        List<String> projectsAndCategoryIds = this.splitProjectAndCategoryIds(projectsOrCategories);
        ArrayList<Category> categories = new ArrayList<Category>();
        if (!projectsAndCategoryIds.isEmpty()) {
            if (projectsAndCategoryIds.contains("catallCategories")) {
                Collection allCategories = this.projectManager.getAllProjectCategories();
                for (ProjectCategory projectCategory : allCategories) {
                    Category category = this.getCategoryData(user, projectCategory, showStats);
                    if (category == null || category.projects.size() <= 0) continue;
                    categories.add(category);
                }
                Category category = this.getCategoryData(user, null, showStats);
                if (category != null && category.projects.size() > 0) {
                    categories.add(category);
                }
            } else if (projectsAndCategoryIds.contains("allprojects")) {
                Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)projects.size());
                Iterator projectCategory = projects.iterator();
                while (projectCategory.hasNext()) {
                    Project project = (Project)projectCategory.next();
                    arrayList.add(this.getProjectDataNoPermissionCheck(user, project, showStats));
                }
                if (!arrayList.isEmpty()) {
                    categories.add(new Category(null, null, arrayList));
                }
            } else if (projectsAndCategoryIds.get(0).startsWith("cat")) {
                for (String string : projectsAndCategoryIds) {
                    Category category;
                    ProjectCategory projectcat = this.projectManager.getProjectCategoryObject(Long.valueOf(string.substring(3)));
                    if (projectcat == null || (category = this.getCategoryData(user, projectcat, showStats)) == null || category.projects.size() <= 0) continue;
                    categories.add(category);
                }
            } else {
                ArrayList projectData = Lists.newArrayListWithCapacity((int)projectsAndCategoryIds.size());
                for (String projectId : projectsAndCategoryIds) {
                    DetailedProjectData detailedProjectData;
                    Project project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId)));
                    if (project == null || (detailedProjectData = this.getProjectData(user, project, showStats)) == null) continue;
                    projectData.add(detailedProjectData);
                }
                if (!projectData.isEmpty()) {
                    categories.add(new Category(null, null, projectData));
                }
            }
        }
        boolean isAdmin = this.permissionManager.hasPermission(0, user);
        boolean bl = !this.projectManager.getProjectObjects().isEmpty();
        return Response.ok((Object)new Projects(categories, isAdmin, bl)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Category getCategoryData(ApplicationUser user, ProjectCategory projectcat, boolean showStats) {
        Category category = null;
        Collection projects = projectcat == null ? this.projectManager.getProjectObjectsWithNoCategory() : this.projectManager.getProjectsFromProjectCategory(projectcat);
        ArrayList<DetailedProjectData> projectData = new ArrayList<DetailedProjectData>(projects.size());
        for (Project project : projects) {
            DetailedProjectData projectBean = this.getProjectData(user, project, showStats);
            if (projectBean == null) continue;
            projectData.add(projectBean);
        }
        if (!projects.isEmpty()) {
            category = new Category(projectcat == null ? null : projectcat.getId(), projectcat == null ? null : projectcat.getName(), projectData);
        }
        return category;
    }

    private DetailedProjectData getProjectData(ApplicationUser user, Project project, boolean showStats) {
        DetailedProjectData projectBean = null;
        if (this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) {
            projectBean = this.getProjectDataNoPermissionCheck(user, project, showStats);
        }
        return projectBean;
    }

    private DetailedProjectData getProjectDataNoPermissionCheck(ApplicationUser user, Project project, boolean showStats) {
        List<OpenIssuesData> openIssues = null;
        String projectDescription = null;
        boolean showOpen = false;
        boolean showDescription = false;
        if (showStats && this.isPriorityFieldVisible(project).booleanValue()) {
            openIssues = this.getOpenIssuesData(project);
            showOpen = true;
        }
        if (showStats && StringUtils.isNotBlank((String)project.getDescription())) {
            projectDescription = this.projectDescriptionRenderer.getViewHtml(project.getDescription());
            showDescription = true;
        }
        ApplicationUser lead = project.getLead();
        return new DetailedProjectData(project.getId(), project.getKey(), project.getName(), project.getLeadUserName(), lead == null ? null : lead.getDisplayName(), openIssues, projectDescription, showOpen, showDescription, project.getAvatar());
    }

    private List<OptionData> getReportData(Project project) {
        List<ProjectTabPanelModuleDescriptor> projectTabPanels = this.getProjectTabPanels(project);
        ArrayList<OptionData> tabPanels = new ArrayList<OptionData>(projectTabPanels.size());
        for (ProjectTabPanelModuleDescriptor tab : projectTabPanels) {
            tabPanels.add(new OptionData(tab.getLabel(), null, "/browse/" + project.getKey() + "?selectedTab=" + tab.getCompleteKey()));
        }
        return tabPanels;
    }

    private List<String> splitProjectAndCategoryIds(String projectsOrCategories) {
        if (projectsOrCategories == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(projectsOrCategories.split("\\|"));
    }

    private List<OptionData> getFilterData(Project project, ApplicationUser user) {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext((String)"", null);
        ProjectHelper jiraHelper = this.getProjectHelper(user, project);
        List simpleLinks = this.simpleLinkManager.getLinksForSection("system.preset.filters", user, (JiraHelper)jiraHelper);
        ArrayList<OptionData> filterData = new ArrayList<OptionData>(simpleLinks.size());
        for (SimpleLink simpleLink : simpleLinks) {
            filterData.add(new OptionData(simpleLink.getLabel(), simpleLink.getTitle(), simpleLink.getUrl()));
        }
        return filterData;
    }

    private List<ProjectTabPanelModuleDescriptor> getProjectTabPanels(Project project) {
        ArrayList<ProjectTabPanelModuleDescriptor> projectTabPanels = new ArrayList<ProjectTabPanelModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectTabPanelModuleDescriptor.class));
        BrowseProjectContext ctx = new BrowseProjectContext(this.authenticationContext.getLoggedInUser(), project);
        Iterator iterator = projectTabPanels.iterator();
        while (iterator.hasNext()) {
            ProjectTabPanelModuleDescriptor descriptor = (ProjectTabPanelModuleDescriptor)iterator.next();
            if (((ProjectTabPanel)descriptor.getModule()).showPanel((BrowseContext)ctx)) continue;
            iterator.remove();
        }
        Collections.sort(projectTabPanels, ModuleDescriptorComparator.COMPARATOR);
        return projectTabPanels;
    }

    private List<OpenIssuesData> getOpenIssuesData(Project project) {
        StatisticAccessorBean sab = this.createStatisticsAccessorBean(project);
        try {
            StatisticMapWrapper stats = sab.getAllFilterBy("priorities");
            ArrayList openIssues = Lists.newArrayListWithCapacity((int)stats.keySet().size());
            I18nBean i18nBean = new I18nBean(this.authenticationContext.getUser());
            for (Priority priority : stats.keySet()) {
                JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
                JqlClauseBuilder clauseBuilder = builder.where().project(new String[]{project.getKey()}).and().resolution().isEmpty();
                if (priority == null) {
                    clauseBuilder.and().priority().isEmpty();
                } else {
                    clauseBuilder.and().priority(new String[]{priority.getId()});
                }
                String priorityId = priority == null ? "-1" : priority.getId();
                openIssues.add(new OpenIssuesData(priority == null ? "none" : priority.getStatusColor(), stats.getPercentage((Object)priority), this.constantsManager.getPriorityName(priorityId) + " - " + stats.getPercentage((Object)priority) + "% (" + stats.get((Object)priority) + " " + i18nBean.getText("gadget.common.issues") + ")", priorityId, this.searchService.getIssueSearchPath(this.authenticationContext.getUser(), SearchService.IssueSearchParameters.builder().query(clauseBuilder.buildQuery()).build())));
            }
            return openIssues;
        }
        catch (SearchException e) {
            return null;
        }
    }

    private StatisticAccessorBean createStatisticsAccessorBean(Project project) {
        return new StatisticAccessorBean(this.authenticationContext.getUser(), project.getId());
    }

    private Boolean isPriorityFieldVisible(Project project) {
        return this.fieldVisibilityManager.isFieldVisible(project.getId(), "priority", "all");
    }

    public ProjectHelper getProjectHelper(ApplicationUser user, Project project) {
        HttpServletRequestWrapper request = new HttpServletRequestWrapper(ExecutingHttpRequest.get()){

            public String getContextPath() {
                return "";
            }
        };
        return new ProjectHelper((HttpServletRequest)request, new BrowseProjectContext(user, project));
    }

    @XmlRootElement
    public static class OpenIssuesData {
        @XmlElement
        private String colour;
        @XmlElement
        private int width;
        @XmlElement
        private String altText;
        @XmlElement
        private String priority;
        @XmlElement
        private String url;

        public OpenIssuesData() {
        }

        public OpenIssuesData(String colour, int width, String altText, String priority, String url) {
            this.colour = colour;
            this.width = width;
            this.altText = altText;
            this.priority = priority;
            this.url = url;
        }
    }

    @XmlRootElement
    public static class OptionData {
        @XmlElement
        private String title;
        @XmlElement
        private String description;
        @XmlElement
        private String key;

        public OptionData() {
        }

        public OptionData(String title, String description, String key) {
            this.title = title;
            this.description = description;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    @XmlRootElement
    public static class OptionDataList {
        @XmlElement
        private List<OptionData> options;

        public OptionDataList() {
        }

        public OptionDataList(List<OptionData> options) {
            this.options = options;
        }

        public List<OptionData> getOptions() {
            return this.options;
        }
    }

    @XmlRootElement
    public static class DetailedProjectData {
        @XmlElement
        long id;
        @XmlElement
        private String key;
        @XmlElement
        private String name;
        @XmlElement
        private boolean showOpen;
        @XmlElement
        private boolean showDescription;
        @XmlElement
        private String leadUserName;
        @XmlElement
        private String leadFullName;
        @XmlElement
        private String projectDescription;
        @XmlElement
        private List<OpenIssuesData> openIssues;
        @XmlElement
        private boolean hasOpenIssuesStats;
        @XmlElement
        private long avatarId;

        DetailedProjectData() {
        }

        DetailedProjectData(long id, String key, String name, String leadUserName, String leadFullName, List<OpenIssuesData> openIssues, String projectDescription, boolean showOpen, boolean showDescription, Avatar avatar) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.leadUserName = leadUserName;
            this.leadFullName = leadFullName;
            this.projectDescription = projectDescription;
            this.showOpen = showOpen;
            this.showDescription = showDescription;
            this.hasOpenIssuesStats = openIssues != null;
            this.openIssues = openIssues;
            this.avatarId = avatar.getId();
        }
    }

    @XmlRootElement
    public static class Category {
        @XmlElement
        private String id;
        @XmlElement
        private String name;
        @XmlElement
        private List<DetailedProjectData> projects;

        public Category() {
        }

        public Category(Long id, String name, List<DetailedProjectData> projects) {
            this.id = id == null ? null : id.toString();
            this.name = name;
            this.projects = projects;
        }
    }

    @XmlRootElement
    public static class Projects {
        @XmlElement
        private List<Category> categories;
        @XmlElement
        private boolean isAdmin;
        @XmlElement
        private boolean doAnyProjectsExist;

        public Projects() {
        }

        public Projects(List<Category> categories, boolean isAdmin, boolean doAnyProjectsExist) {
            this.categories = categories;
            this.isAdmin = isAdmin;
            this.doAnyProjectsExist = doAnyProjectsExist;
        }
    }
}

