/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.PieSegmentWrapper;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;

@Path(value="piechart")
@AnonymousAllowed
@Produces(value={"application/json"})
public class PieChartResource
extends SearchQueryBackedResource {
    private static final String SEARCH_QUERY = "projectOrFilterId";
    static final String STAT_TYPE = "statType";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String NUM_ISSUES = "numIssues";
    private static final String RETURN_DATA = "returnData";
    private static final String INLINE = "inline";
    private final ChartFactory chartFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final StatisticTypesProvider statisticTypesProvider;
    static final String KEY_URL_GENERATOR = "completeDatasetUrlGenerator";
    static final String KEY_DATASET = "completeDataset";

    public PieChartResource(@ComponentImport ChartFactory chartFactory, @ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, StatisticTypesProvider statisticTypesProvider, @ComponentImport SearchService searchService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.authenticationContext = authenticationContext;
        this.statisticTypesProvider = statisticTypesProvider;
    }

    @GET
    @Path(value="/generate")
    public Response getPieChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") @DefaultValue(value="assignees") String statType, @QueryParam(value="returnData") @DefaultValue(value="false") boolean returnData, @QueryParam(value="width") @DefaultValue(value="400") int width, @QueryParam(value="height") @DefaultValue(value="250") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        String displayName = this.validateStatType(errors, statType);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        try {
            Chart chart = this.createChart(statType, width, height, user, searchRequest, inline);
            Map chartParams = chart.getParameters();
            String location = chart.getLocation();
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            Long issueCount = (Long)chartParams.get(NUM_ISSUES);
            int chartWidth = (Integer)chartParams.get(WIDTH);
            int chartHeight = (Integer)chartParams.get(HEIGHT);
            String imageMap = chart.getImageMap();
            String imageMapName = chart.getImageMapName();
            DataRow[] data = null;
            if (returnData) {
                data = this.getData(statType, chartParams);
            }
            PieChart pieChart = new PieChart(location, title, filterUrl, issueCount, displayName, imageMap, imageMapName, data, chartWidth, chartHeight, chart.getBase64Image());
            return Response.ok((Object)pieChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    Chart createChart(String statType, int width, int height, ApplicationUser user, SearchRequest searchRequest, boolean inline) {
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        return this.chartFactory.generatePieChart(context, statType);
    }

    DataRow[] getData(String statType, Map<String, Object> chartParams) {
        CategoryURLGenerator completeUrlGenerator = (CategoryURLGenerator)chartParams.get(KEY_URL_GENERATOR);
        CategoryDataset completeDataset = (CategoryDataset)chartParams.get(KEY_DATASET);
        DataRow[] data = this.generateDataSet(completeDataset, completeUrlGenerator);
        this.sort(statType, data);
        return data;
    }

    void sort(String statType, DataRow[] data) {
        Arrays.sort(data, new DataSorter(this.statisticTypesProvider.getStatsMapper(statType).getComparator()));
    }

    DataRow[] generateDataSet(CategoryDataset dataset, CategoryURLGenerator urlGenerator) {
        DataRow[] data = new DataRow[dataset.getColumnCount()];
        for (int col = 0; col < dataset.getColumnCount(); ++col) {
            Comparable key = dataset.getColumnKey(col);
            int val = dataset.getValue(0, col).intValue();
            String url = urlGenerator.generateURL(dataset, 0, col);
            int percentage = dataset.getValue(1, col).intValue();
            data[col] = new DataRow(key, url, val, percentage);
        }
        return data;
    }

    String validateStatType(Collection<ValidationError> errors, String statType) {
        String displayName = this.statisticTypesProvider.getDisplayName(statType);
        if (StringUtils.isBlank((String)displayName)) {
            errors.add(new ValidationError(STAT_TYPE, "gadget.common.invalid.stat.type", statType));
        }
        return displayName;
    }

    @GET
    @Path(value="validate")
    public Response validatePieChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") String statType) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, errors, new HashMap<String, Object>());
        this.validateStatType(errors, statType);
        return this.createValidationResponse(errors);
    }

    @XmlRootElement
    @XmlType(namespace="com.atlassian.jira.gadgets.system.PieChartResource")
    public static class DataRow {
        private Comparable key;
        @XmlElement
        private String url;
        @XmlElement
        private int value;
        @XmlElement
        private int pecentage;
        @XmlElement(name="key")
        private String keyString;

        public DataRow() {
        }

        DataRow(Comparable key, String url, int value, int pecentage) {
            this.key = key;
            this.url = url;
            this.value = value;
            this.pecentage = pecentage;
            this.keyString = key.toString();
        }

        public Comparable getRawKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRow dataRow = (DataRow)o;
            if (this.pecentage != dataRow.pecentage) {
                return false;
            }
            if (this.value != dataRow.value) {
                return false;
            }
            if (this.key != null ? !this.key.equals(dataRow.key) : dataRow.key != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(dataRow.url) : dataRow.url != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + this.value;
            result = 31 * result + this.pecentage;
            return result;
        }
    }

    @XmlRootElement
    public static class PieChart {
        @XmlElement
        private String location;
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private long issueCount;
        @XmlElement
        private String statType;
        @XmlElement
        private String imageMap;
        @XmlElement
        private String imageMapName;
        @XmlElement
        private DataRow[] data;
        @XmlElement
        private int height;
        @XmlElement
        private int width;
        @XmlElement
        private String base64Image;

        private PieChart() {
        }

        PieChart(String location, String filterTitle, String filterUrl, long issueCount, String statType, String imageMap, String imageMapName, DataRow[] data, int width, int height, String base64Image) {
            this.location = location;
            this.filterTitle = filterTitle;
            this.filterUrl = filterUrl;
            this.issueCount = issueCount;
            this.statType = statType;
            this.imageMap = imageMap;
            this.imageMapName = imageMapName;
            this.data = data;
            this.width = width;
            this.height = height;
            this.base64Image = base64Image;
        }
    }

    class DataSorter
    implements Comparator<DataRow> {
        final Comparator comparator;

        public DataSorter(Comparator comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(DataRow dataRow, DataRow dataRow1) {
            if (dataRow == null) {
                if (dataRow1 == null) {
                    return 0;
                }
                return 1;
            }
            if (dataRow1 == null) {
                return -1;
            }
            return this.comparator.compare(((PieSegmentWrapper)dataRow.getRawKey()).getKey(), ((PieSegmentWrapper)dataRow1.getRawKey()).getKey());
        }
    }
}

