/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/login")
@AnonymousAllowed
@Produces(value={"application/json"})
public class LoginGadgetResource {
    private final JiraAuthenticationContext authenticationContext;
    private final LoginService loginService;

    public LoginGadgetResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport LoginService loginService) {
        this.authenticationContext = authenticationContext;
        this.loginService = loginService;
    }

    @POST
    public Response checkLogin(@Context HttpServletRequest request) {
        com.atlassian.jira.bc.security.login.LoginProperties loginProperties = this.loginService.getLoginProperties(this.authenticationContext.getUser(), request);
        return Response.ok((Object)new LoginProperties(loginProperties)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class LoginProperties {
        @XmlElement
        private boolean allowCookies;
        @XmlElement
        private boolean externalUserManagement;
        @XmlElement
        private boolean isPublicMode;
        @XmlElement
        private boolean isElevatedSecurityCheckShown;
        @XmlElement
        private boolean loginSucceeded;
        @XmlElement
        private boolean captchaFailure;
        @XmlElement
        private boolean loginError;
        @XmlElement
        private boolean communicationError;
        @XmlElement
        private String contactAdminLink;
        @XmlElement
        private boolean loginFailedByPermissions;

        private LoginProperties() {
        }

        public LoginProperties(com.atlassian.jira.bc.security.login.LoginProperties loginProperties) {
            this.loginSucceeded = loginProperties.isLoginSucceeded();
            this.loginError = loginProperties.isLoginError();
            this.communicationError = loginProperties.isCommunicationError();
            this.allowCookies = loginProperties.isAllowCookies();
            this.externalUserManagement = loginProperties.isExternalUserManagement();
            this.isPublicMode = loginProperties.isPublicMode();
            this.isElevatedSecurityCheckShown = loginProperties.isElevatedSecurityCheckShown();
            this.captchaFailure = loginProperties.isCaptchaFailure();
            this.loginFailedByPermissions = loginProperties.getLoginFailedByPermissions();
            this.contactAdminLink = loginProperties.getContactAdminLink();
        }
    }
}

