/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/currentUser")
@Produces(value={"application/json"})
public class GadgetUserResource {
    private final JiraAuthenticationContext authenticationContext;

    public GadgetUserResource(@ComponentImport JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @GET
    public Response getCurrentUser() {
        ApplicationUser user = this.authenticationContext.getUser();
        if (user == null) {
            return Response.status((int)401).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)new UserBean(user.getName(), user.getDisplayName(), user.getEmailAddress())).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class UserBean {
        @XmlElement
        private String username;
        @XmlElement
        private String fullName;
        @XmlElement
        private String email;

        private UserBean() {
        }

        UserBean(String username, String fullName, String email) {
            this.username = username;
            this.fullName = fullName;
            this.email = email;
        }
    }
}

