/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.filter.FilterViewHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/filtersAndProjects")
@AnonymousAllowed
@Produces(value={"application/json"})
public class FiltersAndProjectsResource {
    private JiraAuthenticationContext authenticationContext;
    private SearchRequestService searchRequestService;
    private FilterViewHelper filterHelper;
    private final PermissionManager permissionManager;
    private I18nHelper.BeanFactory i18nFactory;

    public FiltersAndProjectsResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestService searchRequestService, @ComponentImport ShareTypeFactory shareTypeFactory, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nHelper.BeanFactory i18nFactory) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
        this.filterHelper = new FilterViewHelper(shareTypeFactory, authenticationContext, "dummy", "dummy", searchRequestService);
    }

    @GET
    public Response getFilters(@DefaultValue(value="true") @QueryParam(value="showFilters") boolean showFilters, @DefaultValue(value="true") @QueryParam(value="showProjects") boolean showProjects) {
        ApplicationUser user = this.authenticationContext.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        ArrayList<GroupWrapper> options = new ArrayList<GroupWrapper>();
        if (showFilters) {
            Collection searchRequests;
            if (user != null) {
                searchRequests = this.searchRequestService.getFavouriteFilters(user);
            } else {
                SimpleErrorCollection errors = new SimpleErrorCollection();
                JiraServiceContextImpl ctx = new JiraServiceContextImpl(user, (ErrorCollection)errors);
                searchRequests = this.filterHelper.getPopularFilters((JiraServiceContext)ctx);
            }
            ArrayList<Option> filters = new ArrayList<Option>(searchRequests.size());
            for (SearchRequest searchRequest : searchRequests) {
                filters.add(new Option(searchRequest.getName(), "filter-" + searchRequest.getId().toString()));
            }
            OptionGroup filterGroup = new OptionGroup(i18nHelper.getText("common.concepts.filters"), filters);
            if (!showProjects) {
                return Response.ok((Object)filterGroup).cacheControl(CacheControl.NO_CACHE).build();
            }
            options.add(new GroupWrapper(filterGroup));
        }
        if (showProjects) {
            Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
            ArrayList<Option> projectOptions = new ArrayList<Option>(projects.size());
            for (Project project : projects) {
                projectOptions.add(new Option(project.getName(), "project-" + project.getId()));
            }
            OptionGroup projectGroup = new OptionGroup(i18nHelper.getText("common.concepts.projects"), projectOptions);
            if (!showFilters) {
                return Response.ok((Object)projectGroup).cacheControl(CacheControl.NO_CACHE).build();
            }
            options.add(new GroupWrapper(projectGroup));
        }
        return Response.ok((Object)new OptionList(options)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @XmlRootElement
    public static class Option {
        @XmlElement
        private String label;
        @XmlElement
        private String value;

        private Option() {
        }

        Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlRootElement
    public static class OptionGroup {
        @XmlElement
        private String label;
        @XmlElement
        private Collection<Option> options;

        private OptionGroup() {
        }

        OptionGroup(String label, Collection<Option> options) {
            this.label = label;
            this.options = options;
        }

        public String getLabel() {
            return this.label;
        }

        public Collection<Option> getOptions() {
            return this.options;
        }
    }

    @XmlRootElement
    public static class GroupWrapper {
        @XmlElement
        private OptionGroup group;

        private GroupWrapper() {
        }

        GroupWrapper(OptionGroup group) {
            this.group = group;
        }

        public OptionGroup getGroup() {
            return this.group;
        }
    }

    @XmlRootElement
    public static class OptionList {
        @XmlElement
        Collection<GroupWrapper> options;

        private OptionList() {
        }

        OptionList(Collection<GroupWrapper> options) {
            this.options = options;
        }

        public Collection<GroupWrapper> getOptions() {
            return this.options;
        }
    }
}

