/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dateFields")
@AnonymousAllowed
@Produces(value={"application/json"})
public class DateFieldsResource {
    private static final Logger log = LoggerFactory.getLogger(DateFieldsResource.class);
    private final FieldManager fieldManager;

    public DateFieldsResource(@ComponentImport FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    @GET
    public Response getAvailableDateFields() {
        try {
            ArrayList navigableFields = new ArrayList(this.fieldManager.getAllAvailableNavigableFields());
            ArrayList<DateFieldBean> fields = new ArrayList<DateFieldBean>(navigableFields.size());
            Collections.sort(navigableFields);
            for (Field field : navigableFields) {
                if (!this.isDateTypeField(field)) continue;
                fields.add(new DateFieldBean(field.getId(), field.getName()));
            }
            DateFieldBean[] returnArray = new DateFieldBean[fields.size()];
            returnArray = fields.toArray(returnArray);
            return Response.ok((Object)returnArray).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (FieldException e) {
            log.error("Error thrown while retreiving navigable fields", (Throwable)e);
            return Response.serverError().cacheControl(CacheControl.NO_CACHE).build();
        }
    }

    private boolean isDateTypeField(Field field) {
        if (this.fieldManager.isCustomField(field)) {
            CustomFieldType customFieldType = ((CustomField)field).getCustomFieldType();
            return customFieldType instanceof DateField;
        }
        return field instanceof DateField;
    }

    @XmlRootElement
    public static class DateFieldBean {
        @XmlElement
        private String label;
        @XmlElement
        private String value;

        private DateFieldBean() {
        }

        DateFieldBean(String value, String label) {
            this.label = label;
            this.value = value;
        }
    }
}

