/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.TimePeriodUtils;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.util.ResourceDateValidator;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.xy.XYDataset;

@Path(value="/createdVsResolved")
@AnonymousAllowed
@Produces(value={"application/json"})
public class CreatedVsResolvedResource
extends SearchQueryBackedResource {
    public static final String DAYS_NAME = "daysprevious";
    private static final String PERIOD_NAME = "periodName";
    public static final String VERSION_LABEL = "versionLabel";
    private static final String IS_CUMULATIVE = "isCumulative";
    private static final String SHOW_UNRESOLVED_TREND = "showUnresolvedTrend";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String NUM_CREATED_ISSUES = "numCreatedIssues";
    private static final String RETURN_DATA = "returnData";
    private static final String NUM_RESOLVED_ISSUES = "numResolvedIssues";
    private static final String INLINE = "inline";
    private final ChartFactory chartFactory;
    private final ResourceDateValidator resourceDateValidator;
    private final TimeZoneManager timeZoneManager;

    public CreatedVsResolvedResource(@ComponentImport ChartFactory chartFactory, @ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport SearchService searchService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport TimeZoneManager timeZoneManager) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.chartFactory = chartFactory;
        this.timeZoneManager = timeZoneManager;
        this.resourceDateValidator = new ResourceDateValidator(applicationProperties);
    }

    @GET
    @Path(value="/generate")
    public Response generateChart(@Context HttpServletRequest request, @QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="versionLabel") @DefaultValue(value="major") String versionLabel, @QueryParam(value="isCumulative") @DefaultValue(value="true") boolean isCumulative, @QueryParam(value="showUnresolvedTrend") @DefaultValue(value="false") boolean showUnresolvedTrend, @QueryParam(value="returnData") @DefaultValue(value="false") boolean returnData, @QueryParam(value="width") @DefaultValue(value="450") int width, @QueryParam(value="height") @DefaultValue(value="300") int height, @QueryParam(value="inline") @DefaultValue(value="false") boolean inline) {
        if (StringUtils.isNotBlank((String)queryString) && !queryString.contains("-")) {
            queryString = "filter-" + queryString;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        int numberOfDays = this.resourceDateValidator.validateDaysPrevious(DAYS_NAME, period, days, errors);
        ChartFactory.VersionLabel label = this.validateVersionLabel(versionLabel, errors);
        if (!errors.isEmpty()) {
            return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(errors).build()).cacheControl(CacheControl.NO_CACHE).build();
        }
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(user, searchRequest, width, height, inline);
        try {
            Chart chart = this.chartFactory.generateCreatedVsResolvedChart(context, numberOfDays, period, label, isCumulative, showUnresolvedTrend);
            String location = chart.getLocation();
            String title = this.getFilterTitle(params);
            String filterUrl = this.getFilterUrl(params);
            Integer issuesCreated = (Integer)chart.getParameters().get(NUM_CREATED_ISSUES);
            Integer issuesResolved = (Integer)chart.getParameters().get(NUM_RESOLVED_ISSUES);
            String imageMap = chart.getImageMap();
            String imageMapName = chart.getImageMapName();
            DataRow[] data = null;
            if (returnData) {
                CategoryDataset completeDataset = (CategoryDataset)chart.getParameters().get("completeDataset");
                XYDataset chartDataset = (XYDataset)chart.getParameters().get("chartDataset");
                XYURLGenerator completeUrlGenerator = (XYURLGenerator)chart.getParameters().get("completeDatasetUrlGenerator");
                data = this.generateDataSet(completeDataset, completeUrlGenerator, chartDataset, showUnresolvedTrend);
            }
            CreatedVsResolvedChart createdVsResolvedChart = new CreatedVsResolvedChart(location, title, filterUrl, issuesCreated, issuesResolved, imageMap, imageMapName, data, width, height, chart.getBase64Image());
            return Response.ok((Object)createdVsResolvedChart).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    private DataRow[] generateDataSet(CategoryDataset dataset, XYURLGenerator urlGenerator, XYDataset chartdataset, boolean showTrend) {
        TimePeriodUtils timePeriodUtils = new TimePeriodUtils(this.timeZoneManager);
        DataRow[] data = new DataRow[dataset.getColumnCount()];
        for (int col = 0; col < dataset.getColumnCount(); ++col) {
            Object key = dataset.getColumnKey(col);
            if (key instanceof RegularTimePeriod) {
                key = timePeriodUtils.prettyPrint((TimePeriod)((RegularTimePeriod)key));
            }
            int createdVal = dataset.getValue(0, col).intValue();
            String createdUrl = urlGenerator.generateURL(chartdataset, 0, col);
            int resolvedVal = dataset.getValue(1, col).intValue();
            String resolvedUrl = urlGenerator.generateURL(chartdataset, 1, col);
            Integer trendCount = null;
            if (showTrend) {
                trendCount = dataset.getValue(2, col).intValue();
            }
            data[col] = new DataRow(key, createdUrl, createdVal, resolvedUrl, resolvedVal, trendCount);
        }
        return data;
    }

    private ChartFactory.VersionLabel validateVersionLabel(String versionLabel, Collection<ValidationError> errors) {
        try {
            return ChartFactory.VersionLabel.valueOf((String)versionLabel);
        }
        catch (IllegalArgumentException e) {
            errors.add(new ValidationError(VERSION_LABEL, "gadget.created.vs.resolved.invalid.version.label"));
            return null;
        }
    }

    @GET
    @Path(value="/validate")
    public Response validateChart(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="daysprevious") @DefaultValue(value="30") String days, @QueryParam(value="periodName") @DefaultValue(value="daily") String periodName, @QueryParam(value="versionLabel") @DefaultValue(value="major") String versionLabel) {
        if (StringUtils.isNotBlank((String)queryString) && !queryString.contains("-")) {
            queryString = "filter-" + queryString;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.getSearchRequestAndValidate(queryString, errors, params);
        ChartFactory.PeriodName period = this.resourceDateValidator.validatePeriod(PERIOD_NAME, periodName, errors);
        this.resourceDateValidator.validateDaysPrevious(DAYS_NAME, period, days, errors);
        this.validateVersionLabel(versionLabel, errors);
        return this.createValidationResponse(errors);
    }

    @XmlRootElement
    @XmlType(namespace="com.atlassian.jira.gadgets.system.CreatedVsResolvedResource")
    public static class DataRow {
        private Object key;
        @XmlElement
        private String createdUrl;
        @XmlElement
        private int createdValue;
        @XmlElement
        private String resolvedUrl;
        @XmlElement
        private int resolvedValue;
        @XmlElement
        private Integer trendCount;
        @XmlElement(name="key")
        private String keyString;

        public DataRow() {
        }

        DataRow(Object key, String createdUrl, int createdValue, String resolvedUrl, int resolvedValue, Integer trendCount) {
            this.key = key;
            this.createdUrl = createdUrl;
            this.createdValue = createdValue;
            this.resolvedUrl = resolvedUrl;
            this.resolvedValue = resolvedValue;
            this.trendCount = trendCount;
            this.keyString = key.toString();
        }

        public String getKey() {
            return this.key.toString();
        }

        public Object getRawKey() {
            return this.key;
        }

        public String getCreatedUrl() {
            return this.createdUrl;
        }

        public int getCreatedValue() {
            return this.createdValue;
        }

        public String getResolvedUrl() {
            return this.resolvedUrl;
        }

        public int getResolvedValue() {
            return this.resolvedValue;
        }

        public Integer getTrendCount() {
            return this.trendCount;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    @XmlRootElement
    public static class CreatedVsResolvedChart {
        @XmlElement
        private String location;
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private int issuesCreated;
        @XmlElement
        private int issuesResolved;
        @XmlElement
        private String imageMap;
        @XmlElement
        private String imageMapName;
        @XmlElement
        private DataRow[] data;
        @XmlElement
        private int width;
        @XmlElement
        private int height;
        @XmlElement
        protected String base64Image;

        private CreatedVsResolvedChart() {
        }

        CreatedVsResolvedChart(String location, String filterTitle, String filterUrl, int issuesCreated, int issuesResolved, String imageMap, String imageMapName, DataRow[] data, int width, int height, String base64Image) {
            this.location = location;
            this.filterTitle = filterTitle;
            this.filterUrl = filterUrl;
            this.issuesCreated = issuesCreated;
            this.issuesResolved = issuesResolved;
            this.imageMap = imageMap;
            this.imageMapName = imageMapName;
            this.data = data;
            this.width = width;
            this.height = height;
            this.base64Image = base64Image;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFilterTitle() {
            return this.filterTitle;
        }

        public String getFilterUrl() {
            return this.filterUrl;
        }

        public int getIssuesCreated() {
            return this.issuesCreated;
        }

        public int getIssuesResolved() {
            return this.issuesResolved;
        }

        public String getImageMap() {
            return this.imageMap;
        }

        public String getImageMapName() {
            return this.imageMapName;
        }

        public DataRow[] getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

