/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FieldNameComparator;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/availableColumns")
@AnonymousAllowed
@Produces(value={"application/json"})
public class AvailableColumnsResource {
    private JiraAuthenticationContext authenticationContext;
    private final FieldManager fieldManager;
    private final TableLayoutUtils tableLayoutUtils;

    public AvailableColumnsResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport FieldManager fieldManager, @ComponentImport TableLayoutUtils tableLayoutUtils) {
        this.authenticationContext = authenticationContext;
        this.fieldManager = fieldManager;
        this.tableLayoutUtils = tableLayoutUtils;
    }

    @GET
    public Response getColumns() {
        try {
            List<NavigableField> fields = this.getFields();
            List<NavigableField> defaults = this.getDefaultColumns(fields);
            ColumnOptions layout = new ColumnOptions(this.convertToColumnItems(fields), this.convertToColumnItems(defaults));
            return Response.ok((Object)layout).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (FieldException e) {
            throw new RuntimeException(e);
        }
    }

    private List<NavigableField> getFields() throws FieldException {
        ApplicationUser user = this.authenticationContext.getUser();
        Set fields = this.fieldManager.getAvailableNavigableFields(user);
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CustomField customField;
            NavigableField field = (NavigableField)iterator.next();
            if (!(field instanceof CustomField) || (customField = (CustomField)field).getCustomFieldType().getDescriptor().isViewTemplateExists() || customField.getCustomFieldType().getDescriptor().isColumnViewTemplateExists()) continue;
            iterator.remove();
        }
        FieldNameComparator nameComparator = new FieldNameComparator(this.authenticationContext.getI18nHelper());
        ArrayList<NavigableField> orderedFields = new ArrayList<NavigableField>(fields);
        Collections.sort(orderedFields, nameComparator);
        return orderedFields;
    }

    private List<NavigableField> getDefaultColumns(List<NavigableField> availableFields) {
        List colStrings = this.tableLayoutUtils.getDefaultColumnNames("jira.table.cols.dashboard");
        ArrayList<NavigableField> defaultFields = new ArrayList<NavigableField>(colStrings.size());
        block0: for (String colString : colStrings) {
            for (NavigableField field : availableFields) {
                if (!field.getId().equals(colString)) continue;
                defaultFields.add(field);
                continue block0;
            }
        }
        return defaultFields;
    }

    private List<ColumnOptions.ColumnItem> convertToColumnItems(List<NavigableField> fields) {
        ArrayList<ColumnOptions.ColumnItem> items = new ArrayList<ColumnOptions.ColumnItem>(fields.size());
        for (NavigableField field : fields) {
            items.add(new ColumnOptions.ColumnItem(field.getId(), field.getName()));
        }
        return items;
    }
}

