/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.rest.api.messages.TextMessage;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.core.Response;

public abstract class AbstractResource {
    protected Response createErrorResponse(Collection<ValidationError> errors) {
        return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(errors).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    protected Response createIndexingUnavailableResponse(String message) {
        HashSet<String> messages = new HashSet<String>();
        messages.add(message);
        return Response.status((int)503).entity((Object)ErrorCollection.Builder.newBuilder(messages).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    protected Response createValidationResponse(Collection<ValidationError> errors) {
        if (errors.isEmpty()) {
            return Response.ok((Object)new TextMessage("No input validation errors found.")).cacheControl(CacheControl.NO_CACHE).build();
        }
        return this.createErrorResponse(errors);
    }
}

