/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.util;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.dashboarditem.statistics.util.QueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryParserImpl
implements QueryParser {
    private final SearchService searchService;

    @Autowired
    public QueryParserImpl(@ComponentImport SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    @Nonnull
    public Either<Query, ErrorCollection> getQuery(@Nullable ApplicationUser user, @Nonnull String jql) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            errors.addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
            return Either.right((Object)errors);
        }
        Query jqlQuery = parseResult.getQuery();
        MessageSet messages = this.searchService.validateQuery(user, jqlQuery);
        if (messages.hasAnyErrors()) {
            errors.addErrorMessages((Collection)messages.getErrorMessages());
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
            return Either.right((Object)errors);
        }
        return Either.left((Object)jqlQuery);
    }
}

