/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.util;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.dashboarditem.statistics.util.ProjectOrFilterQueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryUrlSupplier;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SavedFilterSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.util.TerminalClauseCollectingVisitor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.SingleValueOperand;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectOrFilterQueryParserImpl
implements ProjectOrFilterQueryParser {
    private final QueryUrlSupplier queryUrlSupplier;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final ProjectService projectService;
    public static final String PROJECT_CLAUSE_NAME = SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName();
    public static final String FILTER_CLAUSE_NAME = SavedFilterSearchConstants.getInstance().getJqlClauseNames().getPrimaryName();

    @Autowired
    public ProjectOrFilterQueryParserImpl(QueryUrlSupplier queryUrlSupplier, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestService searchRequestService, @ComponentImport ProjectService projectService) {
        this.queryUrlSupplier = queryUrlSupplier;
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.projectService = projectService;
    }

    @Override
    @Nonnull
    public ProjectOrFilterQueryParser.QueryInformation getQueryInformation(@Nullable ApplicationUser user, @Nonnull Query query) {
        TerminalClause projectClause;
        SingleValueOperand operand;
        ProjectService.GetProjectResult projectResult;
        String filterName = this.authenticationContext.getI18nHelper().getText("jira.jql.query");
        String filterUrl = this.queryUrlSupplier.getUrlForQuery(query);
        if (this.isFilterOnlyClause(query)) {
            TerminalClause filterClause = this.getFilterClause(query);
            Long filterId = ((SingleValueOperand)filterClause.getOperand()).getLongValue();
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection()), filterId);
            if (filter != null) {
                filterName = filter.getName();
                filterUrl = this.queryUrlSupplier.getUrlForFilter(filterId);
            }
        } else if (this.isProjectOnlyClause(query) && (projectResult = (operand = (SingleValueOperand)(projectClause = this.getProjectClause(query)).getOperand()).getStringValue() != null ? this.projectService.getProjectByKey(user, operand.getStringValue()) : this.projectService.getProjectById(user, operand.getLongValue())).isValid()) {
            filterName = projectResult.getProject().getName();
        }
        return new ProjectOrFilterQueryParser.QueryInformation(filterName, filterUrl);
    }

    @Override
    @Nonnull
    public Option<Query> getFilterQuery(@Nullable ApplicationUser user, @Nonnull Query query) {
        TerminalClause filterClause = this.getFilterClause(query);
        if (filterClause == null) {
            return Option.none();
        }
        Long filterId = ((SingleValueOperand)filterClause.getOperand()).getLongValue();
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection()), filterId);
        if (filter != null) {
            return Option.some((Object)filter.getQuery());
        }
        return Option.none();
    }

    private boolean isProjectOnlyClause(@Nonnull Query query) {
        return this.getNumberClauses(query) == 1 && this.getProjectClause(query) != null;
    }

    private boolean isFilterOnlyClause(@Nonnull Query query) {
        return this.getNumberClauses(query) == 1 && this.getFilterClause(query) != null;
    }

    @Nullable
    private TerminalClause getProjectClause(@Nonnull Query query) {
        return this.getClause(query, PROJECT_CLAUSE_NAME);
    }

    @Nullable
    private TerminalClause getClause(@Nonnull Query query, @Nonnull String clauseName) {
        NamedTerminalClauseCollectingVisitor projectVisitor = new NamedTerminalClauseCollectingVisitor(clauseName);
        query.getWhereClause().accept((ClauseVisitor)projectVisitor);
        if (projectVisitor.getNamedClauses().size() != 1) {
            return null;
        }
        TerminalClause clause = (TerminalClause)projectVisitor.getNamedClauses().get(0);
        if (!(clause.getOperand() instanceof SingleValueOperand)) {
            return null;
        }
        return clause;
    }

    private int getNumberClauses(@Nonnull Query query) {
        TerminalClauseCollectingVisitor clauseVisitor = new TerminalClauseCollectingVisitor();
        if (query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)clauseVisitor);
        }
        return clauseVisitor.getClauses().size();
    }

    @Nullable
    private TerminalClause getFilterClause(@Nonnull Query query) {
        return this.getClause(query, FILTER_CLAUSE_NAME);
    }

    @Nonnull
    private String urlEncode(@Nonnull String string) {
        return JiraUrlCodec.encode((String)string);
    }
}

