/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.service.statistics;

import com.atlassian.fugue.Either;
import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.StatisticsService;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.beans.OneDimensionalStatisticsResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher.StatisticsSearcher;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher.beans.StatisticsSearchResultBean;
import com.atlassian.jira.dashboarditem.statistics.util.ProjectOrFilterQueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryParser;
import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsServiceImpl
implements StatisticsService {
    private static final String SEARCH_JQL = "jql";
    private static final String STAT_TYPE = "statType";
    private static final String FILTER_ID = "filterId";
    private final JiraAuthenticationContext authenticationContext;
    private final StatisticsSearcher statisticsSearcher;
    private final StatisticTypesProvider statisticTypesProvider;
    private final QueryParser queryParser;
    private final ProjectOrFilterQueryParser projectOrFilterQueryParser;
    private final SearchRequestService searchRequestService;

    @Autowired
    public StatisticsServiceImpl(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestService searchRequestService, StatisticsSearcher statisticsSearcher, StatisticTypesProvider statisticTypesProvider, QueryParser queryParser, ProjectOrFilterQueryParser projectOrFilterQueryParser) {
        this.authenticationContext = authenticationContext;
        this.statisticsSearcher = statisticsSearcher;
        this.statisticTypesProvider = statisticTypesProvider;
        this.queryParser = queryParser;
        this.projectOrFilterQueryParser = projectOrFilterQueryParser;
        this.searchRequestService = searchRequestService;
    }

    @Override
    public Either<OneDimensionalStatisticsResultBean, ErrorCollection> aggregateOneDimensionalStats(String jql, Long filterId, @Nonnull String statType) {
        StatisticsSearchResultBean statBean;
        String jqlQueryString;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ErrorCollection errors = this.validParameters(jql, filterId, statType);
        if (errors.hasAnyErrors()) {
            return Either.right((Object)errors);
        }
        String string = jqlQueryString = filterId != null ? this.jqlSearchForFilter(filterId) : jql;
        if (jqlQueryString == null) {
            SimpleErrorCollection queryStringErrors = new SimpleErrorCollection();
            queryStringErrors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.error.generating.response", FILTER_ID));
            queryStringErrors.addReason(ErrorCollection.Reason.NOT_FOUND);
            return Either.right((Object)queryStringErrors);
        }
        Either<Query, ErrorCollection> queryOrError = this.queryParser.getQuery(user, jqlQueryString);
        if (queryOrError.isRight()) {
            return Either.right((Object)queryOrError.right().get());
        }
        Query jqlQuery = (Query)queryOrError.left().get();
        Either<ErrorCollection, String> statOrError = this.getStatDisplayName(statType);
        if (statOrError.isLeft()) {
            return Either.right((Object)statOrError.left().get());
        }
        String statTypeDisplayName = (String)statOrError.right().get();
        try {
            statBean = this.statisticsSearcher.completeOneDimensionalSearch(user, jqlQuery, statType);
        }
        catch (SearchException e) {
            SimpleErrorCollection searchErrors = new SimpleErrorCollection();
            searchErrors.addErrorMessage(e.getMessage());
            searchErrors.addReason(ErrorCollection.Reason.SERVER_ERROR);
            return Either.right((Object)searchErrors);
        }
        return Either.left((Object)this.getStatisticsResult(user, statTypeDisplayName, jqlQuery, statBean));
    }

    @Nonnull
    private Either<ErrorCollection, String> getStatDisplayName(@Nonnull String statType) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String statTypeDisplayName = this.statisticTypesProvider.getDisplayName(statType);
        if (StringUtils.isBlank((String)statTypeDisplayName)) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("gadget.common.invalid.stat.type", statType));
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
            return Either.left((Object)errors);
        }
        return Either.right((Object)statTypeDisplayName);
    }

    private OneDimensionalStatisticsResultBean getStatisticsResult(ApplicationUser user, String statTypeDisplayName, Query jqlQuery, StatisticsSearchResultBean statBean) {
        ProjectOrFilterQueryParser.QueryInformation queryInformation = this.projectOrFilterQueryParser.getQueryInformation(user, jqlQuery);
        String filterName = queryInformation.getName();
        String filterUrl = queryInformation.getUrl();
        return new OneDimensionalStatisticsResultBean(filterName, filterUrl, statTypeDisplayName, statBean);
    }

    private String jqlSearchForFilter(Long filterId) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
        if (filter == null) {
            return null;
        }
        return filter.getQuery().getQueryString();
    }

    private ErrorCollection validParameters(@Nullable String jql, @Nullable Long filterId, @Nullable String statType) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (jql == null && filterId == null) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", SEARCH_JQL));
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", FILTER_ID));
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isBlank((String)statType)) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", STAT_TYPE));
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errors;
    }
}

