/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.service.datecount;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.DateCountInPeriodService;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.beans.DateCountInPeriodResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.beans.FieldResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.beans.TimePeriodResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.field.Field;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.operation.Operation;
import com.atlassian.jira.dashboarditem.statistics.service.datecount.period.TimePeriod;
import com.atlassian.jira.dashboarditem.statistics.service.versions.VersionsService;
import com.atlassian.jira.dashboarditem.statistics.service.versions.beans.ProjectVersionBean;
import com.atlassian.jira.dashboarditem.statistics.util.ProjectOrFilterQueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryParser;
import com.atlassian.jira.dashboarditem.statistics.util.QueryUrlSupplier;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.DatePeriodStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.OneDimensionalObjectHitCollector;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.Collector;
import org.jfree.data.time.RegularTimePeriod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DateCountInPeriodServiceImpl
implements DateCountInPeriodService {
    private final QueryParser queryParser;
    private final QueryUrlSupplier queryUrlSupplier;
    private final ProjectOrFilterQueryParser projectOrFilterQueryParser;
    private final VersionsService versionsService;
    private final SearchProvider searchProvider;
    private final TimeZoneManager timeZoneManager;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public DateCountInPeriodServiceImpl(QueryParser queryParser, QueryUrlSupplier queryUrlSupplier, ProjectOrFilterQueryParser projectOrFilterQueryParser, VersionsService versionsService, @ComponentImport SearchProvider searchProvider, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.queryParser = queryParser;
        this.queryUrlSupplier = queryUrlSupplier;
        this.projectOrFilterQueryParser = projectOrFilterQueryParser;
        this.versionsService = versionsService;
        this.searchProvider = searchProvider;
        this.timeZoneManager = timeZoneManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public Either<DateCountInPeriodResultBean, ErrorCollection> collectData(@Nonnull DateCountInPeriodService.RequestParameters params) {
        ErrorCollection validationErrors = this.validateParameters(params.getJql(), params.getFields(), params.getPeriod(), params.getDaysPrevious(), params.getOperation());
        if (validationErrors.hasAnyErrors()) {
            return Either.right((Object)validationErrors);
        }
        ApplicationUser user = this.authenticationContext.getUser();
        Either<Query, ErrorCollection> queryOrError = this.queryParser.getQuery(user, params.getJql());
        if (queryOrError.isRight()) {
            return Either.right((Object)queryOrError.right().get());
        }
        Query query = (Query)queryOrError.left().get();
        HashMap<Field, Map<RegularTimePeriod, Number>> dataMaps = new HashMap<Field, Map<RegularTimePeriod, Number>>();
        for (Field field : params.getFields()) {
            if (field.getDocumentConstant() == null) continue;
            try {
                dataMaps.put(field, this.getIssuesForField(field, query, params.getDaysPrevious(), user, params.getPeriod()));
            }
            catch (SearchException ex) {
                SimpleErrorCollection errors = new SimpleErrorCollection();
                errors.addErrorMessage(ex.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
                return Either.right((Object)errors);
            }
        }
        this.normaliseDataMaps(dataMaps, params.getDaysPrevious(), params.getPeriod());
        if (params.getFields().contains((Object)Field.unresolvedTrend) && params.getFields().contains((Object)Field.created) && params.getFields().contains((Object)Field.resolved)) {
            TreeMap<RegularTimePeriod, Integer> unresolvedTrendDataMap = new TreeMap<RegularTimePeriod, Integer>();
            Map createdDataMap = (Map)dataMaps.get((Object)Field.created);
            Map resolvedDataMap = (Map)dataMaps.get((Object)Field.resolved);
            int unresolvedTrend = 0;
            for (RegularTimePeriod key : createdDataMap.keySet()) {
                Integer created = (Integer)createdDataMap.get(key);
                Integer resolved = (Integer)resolvedDataMap.get(key);
                unresolvedTrend = unresolvedTrend + created - resolved;
                unresolvedTrendDataMap.put(key, unresolvedTrend);
            }
            dataMaps.put(Field.unresolvedTrend, unresolvedTrendDataMap);
        }
        List versions = Lists.newArrayList();
        if (params.isIncludeVersions()) {
            Either<List<ProjectVersionBean>, ErrorCollection> versionResult = this.versionsService.getVersions(params.getJql());
            if (versionResult.isRight()) {
                return Either.right((Object)versionResult.right().get());
            }
            versions = (List)versionResult.left().get();
        }
        return Either.left((Object)this.generateResult(user, query, params.getDaysPrevious(), params.getOperation(), dataMaps, versions));
    }

    private void normaliseDataMaps(Map<Field, Map<RegularTimePeriod, Number>> dataMaps, Integer daysPrevious, TimePeriod period) {
        if (dataMaps.size() == 0) {
            return;
        }
        Field firstField = dataMaps.keySet().iterator().next();
        DataUtils.normaliseDateRangeCount(dataMaps.get((Object)firstField), (int)(daysPrevious - 1), period.getTimePeriodClass(), (TimeZone)this.timeZoneManager.getLoggedInUserTimeZone());
        for (Field field : dataMaps.keySet()) {
            if (field.equals((Object)firstField)) continue;
            DataUtils.normaliseMapKeys(dataMaps.get((Object)firstField), dataMaps.get((Object)field));
        }
    }

    private Map<RegularTimePeriod, Number> getIssuesForField(@Nonnull Field field, @Nonnull Query query, @Nonnull Integer daysPrevious, @Nullable ApplicationUser user, @Nonnull TimePeriod period) throws SearchException {
        Query timeBoundedQuery = this.buildTimeBoundedQuery(field, query, daysPrevious);
        TimeZone timeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        DatePeriodStatisticsMapper fieldMapper = new DatePeriodStatisticsMapper(period.getTimePeriodClass(), field.getDocumentConstant(), timeZone);
        TreeMap<RegularTimePeriod, Number> result = new TreeMap<RegularTimePeriod, Number>();
        OneDimensionalObjectHitCollector hitCollector = new OneDimensionalObjectHitCollector((StatisticsMapper)fieldMapper, result, true);
        this.searchProvider.search(timeBoundedQuery, user, (Collector)hitCollector);
        return result;
    }

    @VisibleForTesting
    Query buildTimeBoundedQuery(@Nonnull Field field, @Nonnull Query query, @Nonnull Integer daysPrevious) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
        JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
        Option systemClauseInfo = Option.option((Object)SystemSearchConstants.getClauseInformationById((String)field.getDocumentConstant()));
        Option primaryName = Option.option((Object)(systemClauseInfo.isDefined() ? ((ClauseInformation)systemClauseInfo.get()).getJqlClauseNames().getPrimaryName() : field.getDocumentConstant()));
        if (primaryName.isDefined()) {
            whereClauseBuilder.addStringCondition((String)primaryName.get(), Operator.GREATER_THAN_EQUALS, "-" + daysPrevious + "d");
        }
        return whereClauseBuilder.buildQuery();
    }

    private List<TimePeriodResultBean> createTimePeriodResults(Query query, Integer daysPrevious, Boolean isCumulative, Map<Field, Map<RegularTimePeriod, Number>> dataMaps) {
        Set<RegularTimePeriod> timePeriods = this.getTimePeriodsKeySet(dataMaps);
        ArrayList<TimePeriodResultBean> timePeriodResultBeans = new ArrayList<TimePeriodResultBean>();
        for (RegularTimePeriod timePeriod : timePeriods) {
            HashMap<String, FieldResultBean> data = new HashMap<String, FieldResultBean>();
            for (Field field : dataMaps.keySet()) {
                Integer value = (Integer)dataMaps.get((Object)field).get(timePeriod);
                String url = null;
                if (field.getDocumentConstant() != null) {
                    Query timePeriodQueryForField = this.getTimePeriodQueryForField(query, daysPrevious, isCumulative, timePeriod, field);
                    url = this.queryUrlSupplier.getUrlForQuery(timePeriodQueryForField);
                }
                data.put(field.toString(), new FieldResultBean(value, url));
            }
            timePeriodResultBeans.add(new TimePeriodResultBean(timePeriod.getStart(), timePeriod.getEnd(), data));
        }
        return timePeriodResultBeans;
    }

    private Query getTimePeriodQueryForField(Query query, Integer daysPrevious, Boolean isCumulative, RegularTimePeriod timePeriod, Field field) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
        JqlClauseBuilder whereClauseBuilder = jqlQueryBuilder.where().defaultAnd();
        whereClauseBuilder.addStringCondition(field.getDocumentConstant(), Operator.GREATER_THAN_EQUALS, "-" + daysPrevious + "d");
        Date lastDate = timePeriod.getEnd();
        lastDate.setTime(lastDate.getTime() + 1L);
        if (!isCumulative.booleanValue()) {
            whereClauseBuilder.addDateCondition(field.getDocumentConstant(), Operator.GREATER_THAN_EQUALS, timePeriod.getStart());
        }
        whereClauseBuilder.addDateCondition(field.getDocumentConstant(), Operator.LESS_THAN, lastDate);
        return whereClauseBuilder.buildQuery();
    }

    private Set<RegularTimePeriod> getTimePeriodsKeySet(Map<Field, Map<RegularTimePeriod, Number>> data) {
        if (data.size() == 0) {
            throw new IllegalArgumentException("Expected data keyset to be non-empty");
        }
        Field aField = data.keySet().iterator().next();
        return data.get((Object)aField).keySet();
    }

    private Map<String, Integer> createTotals(Map<Field, Map<RegularTimePeriod, Number>> dataMaps) {
        HashMap<String, Integer> totals = new HashMap<String, Integer>();
        for (Field field : dataMaps.keySet()) {
            if (field.equals((Object)Field.unresolvedTrend)) continue;
            totals.put(field.toString(), DataUtils.getTotalNumber(dataMaps.get((Object)field)));
        }
        return totals;
    }

    private void makeCumulative(Map<Field, Map<RegularTimePeriod, Number>> dataMaps) {
        for (Field field : dataMaps.keySet()) {
            if (field.equals((Object)Field.unresolvedTrend)) continue;
            DataUtils.makeCumulative(dataMaps.get((Object)field));
        }
    }

    private DateCountInPeriodResultBean generateResult(ApplicationUser user, Query jqlQuery, Integer daysPrevious, Operation operation, Map<Field, Map<RegularTimePeriod, Number>> dataMaps, List<ProjectVersionBean> versions) {
        Map<String, Integer> totals = this.createTotals(dataMaps);
        boolean isCumulative = operation.equals((Object)Operation.cumulative);
        if (isCumulative) {
            this.makeCumulative(dataMaps);
        }
        List<TimePeriodResultBean> timePeriodResults = this.createTimePeriodResults(jqlQuery, daysPrevious, isCumulative, dataMaps);
        ProjectOrFilterQueryParser.QueryInformation queryInformation = this.projectOrFilterQueryParser.getQueryInformation(user, jqlQuery);
        return new DateCountInPeriodResultBean(queryInformation.getName(), queryInformation.getUrl(), totals, timePeriodResults, versions);
    }

    private ErrorCollection validateParameters(@Nullable String jql, @Nullable Set<Field> fields, @Nullable TimePeriod period, @Nullable Integer daysPrevious, @Nullable Operation operation) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (jql == null) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.jql.null"));
        }
        if (fields == null || fields.size() == 0) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.fields.empty"));
        } else {
            for (Field field : fields) {
                if (field != null) continue;
                this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.fields.hasnull"));
            }
        }
        if (period == null) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.period.null"));
        }
        if (daysPrevious == null) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.daysprevious.null"));
        } else if (daysPrevious <= 0) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.daysprevious.positive"));
        }
        if (operation == null) {
            this.addValidationErrorMessage((ErrorCollection)errors, i18nHelper.getText("datecount.service.operation.null"));
        }
        return errors;
    }

    private void addValidationErrorMessage(ErrorCollection errors, String message) {
        errors.addErrorMessage(message, ErrorCollection.Reason.VALIDATION_FAILED);
    }
}

