/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.statistics.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.StatisticsService;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.beans.OneDimensionalStatisticsResultBean;
import com.atlassian.jira.dashboarditem.statistics.service.statistics.searcher.beans.StatisticsSearchResultBean;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/statistics")
@AnonymousAllowed
public class StatisticsResource {
    private static final String SEARCH_JQL = "jql";
    private static final String STAT_TYPE = "statType";
    public static final String FILTER_ID = "filterId";
    private final StatisticsService statisticsService;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;

    public StatisticsResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchRequestService searchRequestService, @ComponentImport SearchService searchService, StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response oneDimensionalSearch(@QueryParam(value="jql") @Nullable String jql, @QueryParam(value="filterId") @Nullable Long filterId, @QueryParam(value="statType") @Nullable String statType) {
        ErrorCollection errors = this.validParameters(jql, filterId, statType);
        Either<OneDimensionalStatisticsResultBean, ErrorCollection> result = errors.hasAnyErrors() ? Either.right((Object)errors) : (filterId != null ? this.oneDimensionalSearchForFilter(filterId, statType) : this.oneDimensionalSearchWithJql(filterId, jql, statType));
        if (result.isRight()) {
            return this.createErrorResponse((ErrorCollection)result.right().get());
        }
        return Response.ok((Object)result.left().get()).build();
    }

    private Either<OneDimensionalStatisticsResultBean, ErrorCollection> oneDimensionalSearchForFilter(Long filterId, String statType) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
        if (filter == null) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.statistics.filter.not.found"));
            errors.addReason(ErrorCollection.Reason.NOT_FOUND);
            return Either.right((Object)errors);
        }
        Either<OneDimensionalStatisticsResultBean, ErrorCollection> searchResult = this.oneDimensionalSearchWithJql(filterId, this.searchService.getJqlString(filter.getQuery()), statType);
        if (searchResult.isLeft()) {
            OneDimensionalStatisticsResultBean oldResult = (OneDimensionalStatisticsResultBean)searchResult.left().get();
            StatisticsSearchResultBean newBean = new StatisticsSearchResultBean(oldResult.getIssueCount(), oldResult.getResults());
            OneDimensionalStatisticsResultBean newResult = new OneDimensionalStatisticsResultBean(filter.getName(), oldResult.getFilterUrl(), oldResult.getStatType(), newBean);
            return Either.left((Object)newResult);
        }
        return searchResult;
    }

    private Either<OneDimensionalStatisticsResultBean, ErrorCollection> oneDimensionalSearchWithJql(Long filterId, String jql, String statType) {
        return this.statisticsService.aggregateOneDimensionalStats(jql, filterId, statType);
    }

    private ErrorCollection validParameters(@Nullable String jql, @Nullable Long filterId, @Nullable String statType) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (jql == null && filterId == null) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", SEARCH_JQL));
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", FILTER_ID));
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isBlank((String)statType)) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("rest.missing.field", STAT_TYPE));
            errors.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errors;
    }

    private Response createErrorResponse(ErrorCollection errors) {
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)errors.getReasons());
        int errorCode = 500;
        if (worstReason != null) {
            errorCode = worstReason.getHttpStatusCode();
        }
        return this.createErrorResponse(errors, errorCode);
    }

    private Response createErrorResponse(ErrorCollection errors, int errorCode) {
        return Response.status((int)errorCode).entity((Object)errors.getErrorMessages()).build();
    }
}

