/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.quicklinks;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.dashboarditem.quicklinks.Link;
import com.atlassian.jira.dashboarditem.quicklinks.LinkLists;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuickLinksProvider {
    private static final String ISSUE_NAVIGATOR_URL = "/secure/IssueNavigator.jspa";
    private static final String ISSUE_NAVIGATOR_URL_WITH_RESET = "/secure/IssueNavigator.jspa?reset=true";
    private static final String ISSUE_NAVIGATOR_URL_WITH_SHOW = "/secure/IssueNavigator.jspa?mode=show";
    private static final String ISSUE_NAVIGATOR_URL_WITH_RESET_AND_HIDE = "/secure/IssueNavigator.jspa?reset=true&hide=true";
    private static final String BROWSE_PROJECTS_URL = "/secure/BrowseProjects.jspa";
    private static final String CREATE_ISSUE_URL = "/secure/CreateIssue!default.jspa";
    private static final String VIEW_PROJECTS_URL = "/secure/project/ViewProjects.jspa";
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final SearchService searchService;

    @Autowired
    public QuickLinksProvider(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PermissionManager permissionManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport SearchService searchService) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
    }

    public LinkLists getLinks() {
        ArrayList<Link> commons = new ArrayList<Link>();
        ArrayList<Link> navigations = new ArrayList<Link>();
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user)) {
            navigations.add(new Link("gadget.quicklinks.browse.projects", BROWSE_PROJECTS_URL, "gadget.quicklinks.browse.projects.title"));
            navigations.add(new Link("gadget.quicklinks.find.issues", ISSUE_NAVIGATOR_URL_WITH_SHOW, "gadget.quicklinks.find.issues.title"));
        }
        if (this.permissionManager.hasProjects(ProjectPermissions.CREATE_ISSUES, user)) {
            navigations.add(new Link("gadget.quicklinks.create.issue", CREATE_ISSUE_URL, "gadget.quicklinks.create.issue.title"));
        }
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && this.permissionManager.hasProjects(ProjectPermissions.ADMINISTER_PROJECTS, user)) {
            navigations.add(new Link("gadget.quicklinks.adminstration", VIEW_PROJECTS_URL, "gadget.quicklinks.administration.title"));
        }
        if (user != null) {
            String url;
            String jql;
            JqlClauseBuilder builder;
            Query query = JqlQueryBuilder.newBuilder().where().unresolved().and().reporterIsCurrentUser().buildQuery();
            String reportedIssuesURL = ISSUE_NAVIGATOR_URL_WITH_RESET_AND_HIDE + this.searchService.getQueryString(user, query);
            commons.add(new Link("gadget.quicklinks.reported.issues", reportedIssuesURL, "gadget.quicklinks.reported.issues.title"));
            if (this.applicationProperties.getOption("jira.option.voting")) {
                builder = JqlQueryBuilder.newClauseBuilder().issueInVotedIssues();
                jql = this.searchService.getQueryString(user, builder.buildQuery());
                url = ISSUE_NAVIGATOR_URL_WITH_RESET + jql;
                commons.add(new Link("gadget.quicklinks.voted.issues", url, "gadget.quicklinks.voted.issues.title"));
            }
            if (this.applicationProperties.getOption("jira.option.watching")) {
                builder = JqlQueryBuilder.newClauseBuilder().issueInWatchedIssues();
                jql = this.searchService.getQueryString(user, builder.buildQuery());
                url = ISSUE_NAVIGATOR_URL_WITH_RESET + jql;
                commons.add(new Link("gadget.quicklinks.watched.issues", url, "gadget.quicklinks.watched.issues.title"));
            }
        }
        return new LinkLists(navigations, commons);
    }
}

