/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboarditem.introduction;

import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IntroContextProvider
implements ContextProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final IntroductionProperty introductionProperty;
    private final ApplicationProperties applicationProperties;
    private final HelpUrls helpUrls;

    public IntroContextProvider(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport IntroductionProperty introductionProperty, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport HelpUrls helpUrls) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.introductionProperty = introductionProperty;
        this.applicationProperties = applicationProperties;
        this.helpUrls = helpUrls;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap newContext = Maps.newHashMap(context);
        String html = this.introductionProperty.getViewHtml();
        if (StringUtils.isBlank((String)html)) {
            newContext.put("isAdmin", this.permissionManager.hasPermission(0, this.authenticationContext.getUser()));
            newContext.put("jira101HelpPath", this.helpUrls.getUrl("jira101"));
            newContext.put("introHelpPath", this.helpUrls.getUrl("introduction"));
            newContext.put("instanceTitle", this.applicationProperties.getDefaultBackedString("jira.title"));
        } else {
            newContext.put("introHtml", html);
        }
        return newContext;
    }
}

