/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeed;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeedStore;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={SubscribedGadgetFeedStore.class})
@Component
public class JiraSubscribedGadgetFeedStore
implements SubscribedGadgetFeedStore {
    static final String KEY = "com.atlassian.gadgets.directory.SubscribedGadgetFeedStore";
    private final PluginSettingsFactory factory;

    @Autowired
    public JiraSubscribedGadgetFeedStore(@ComponentImport PluginSettingsFactory factory) {
        this.factory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    public SubscribedGadgetFeed addFeed(URI feedUri) {
        SubscribedGadgetFeed feed = new SubscribedGadgetFeed(UUID.randomUUID().toString(), feedUri);
        this.put((Map<String, SubscribedGadgetFeed>)ImmutableMap.builder().putAll(this.feeds()).put((Object)feed.getId(), (Object)feed).build());
        return feed;
    }

    public boolean containsFeed(String feedId) {
        return this.feeds().containsKey(feedId);
    }

    public SubscribedGadgetFeed getFeed(String feedId) {
        return this.feeds().get(feedId);
    }

    public Iterable<SubscribedGadgetFeed> getAllFeeds() {
        return this.feeds().values();
    }

    public void removeFeed(String feedId) {
        this.put(Maps.filterKeys(this.feeds(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)feedId))));
    }

    private void put(Map<String, SubscribedGadgetFeed> feeds) {
        PluginSettings settings = this.factory.createGlobalSettings();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Maps.transformValues(feeds, this.serialize()));
        settings.put(KEY, (Object)properties);
    }

    private Map<String, SubscribedGadgetFeed> feeds() {
        PluginSettings settings = this.factory.createGlobalSettings();
        Properties serializedFeeds = (Properties)settings.get(KEY);
        if (serializedFeeds == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder feeds = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : serializedFeeds.entrySet()) {
            String id = (String)entry.getKey();
            feeds.put((Object)id, (Object)new SubscribedGadgetFeed(id, URI.create((String)entry.getValue())));
        }
        return feeds.build();
    }

    private Function<SubscribedGadgetFeed, String> serialize() {
        return Serializer.INSTANCE;
    }

    private static enum Serializer implements Function<SubscribedGadgetFeed, String>
    {
        INSTANCE;


        public String apply(SubscribedGadgetFeed feed) {
            return feed.getUri().toASCIIString();
        }
    }
}

