/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.chartpopup;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.OpenSocialDashboardItemModuleId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.gadgets.dashboard.spi.DashboardItemStateFactory;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.chartpopup.model.Gadget;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/chart")
@Produces(value={"text/html"})
public class ChartPopupResource {
    private static final Logger log = LoggerFactory.getLogger(ChartPopupResource.class);
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/";
    private static final String PREF_PROJECT_OR_FILTER_ID = "projectOrFilterId";
    private static final String PREF_FILTER_ID = "filterId";
    private static final String PREF_JQL = "jql";
    private static final String PREF_IS_POPUP = "isPopup";
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String FILTER_PREFIX = "filter-";
    private static final String JQL_PREFIX = "jql-";
    private final JiraAuthenticationContext authenticationContext;
    private final GadgetViewFactory gadgetViewFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final PortalPageService portalPageService;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final DashboardService dashboardService;
    private final DashboardItemStateFactory gadgetStateFactory;
    private final UserUtil userUtil;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private final VelocityTemplatingEngine templatingEngine;

    public ChartPopupResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GadgetViewFactory gadgetViewFactory, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport PortalPageService portalPageService, @ComponentImport SearchRequestService searchRequestService, @ComponentImport SearchService searchService, @ComponentImport DashboardService dashboardService, @ComponentImport DashboardItemStateFactory gadgetStateFactory, @ComponentImport UserUtil userUtil, @ComponentImport GadgetRequestContextFactory gadgetRequestContextFactory, @ComponentImport SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory, @ComponentImport VelocityTemplatingEngine templatingEngine) {
        this.authenticationContext = authenticationContext;
        this.gadgetViewFactory = gadgetViewFactory;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.portalPageService = portalPageService;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.dashboardService = dashboardService;
        this.gadgetStateFactory = gadgetStateFactory;
        this.userUtil = userUtil;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
        this.templatingEngine = templatingEngine;
    }

    @GET
    @Path(value="/render")
    public Response getChartContents(@QueryParam(value="id") Long gadgetId, @QueryParam(value="gadgetUri") String gadgetUri, @QueryParam(value="filterId") Long filterId, @QueryParam(value="jql") String jql, @Context HttpServletRequest request) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notBlank((String)"gadgetUri", (String)gadgetUri);
        MapBuilder prefsBuilder = MapBuilder.newBuilder();
        prefsBuilder.add((Object)PREF_IS_POPUP, (Object)Boolean.TRUE.toString());
        prefsBuilder.add((Object)PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
        if (filterId != null) {
            prefsBuilder.add((Object)PREF_PROJECT_OR_FILTER_ID, (Object)(FILTER_PREFIX + filterId));
            prefsBuilder.add((Object)PREF_FILTER_ID, (Object)filterId.toString());
        } else {
            String filterJql = JQL_PREFIX + jql;
            prefsBuilder.add((Object)PREF_FILTER_ID, (Object)filterJql);
            prefsBuilder.add((Object)PREF_PROJECT_OR_FILTER_ID, (Object)filterJql);
        }
        Map prefs = prefsBuilder.toMutableMap();
        GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)gadgetId.toString())).specUri(URI.create(gadgetUri)).userPrefs(prefs).build();
        StringWriter out = new StringWriter();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
            GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(request);
            this.gadgetViewFactory.createGadgetView(gadget, ModuleId.valueOf((long)gadgetId), View.DEFAULT, requestContext).writeTo((Writer)gadgetWriter);
            ((Writer)gadgetWriter).flush();
            MapBuilder contextBuilder = MapBuilder.newBuilder().add((Object)"gadgetHtml", (Object)baos.toString());
            ((Writer)out).write(this.renderTemplate("chartpopup.vm", contextBuilder.toMap()));
        }
        catch (IOException e) {
            log.error("Error rendering gadget '" + gadgetUri + "'", (Throwable)e);
            return Response.serverError().entity((Object)("Error rendering gadget '" + gadgetUri + "'")).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)((Object)out).toString()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="/add")
    public Response getGadgetToDashboardForm(@QueryParam(value="filterId") Long filterId, @QueryParam(value="jql") String jql) {
        StringWriter out = new StringWriter();
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        MapBuilder contextBuilder = MapBuilder.newBuilder().add((Object)"portals", (Object)this.portalPageService.getOwnedPortalPages(this.authenticationContext.getUser())).add((Object)"baseurl", (Object)requestContext.getBaseUrl()).add((Object)"textutils", (Object)new TextUtils()).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).add((Object)"displayParameters", (Object)MapBuilder.singletonMap((Object)"theme", (Object)"aui"));
        Map context = filterId != null ? contextBuilder.add((Object)PREF_FILTER_ID, (Object)(FILTER_PREFIX + filterId)).toMap() : contextBuilder.add((Object)PREF_JQL, (Object)jql).toMap();
        try {
            ((Writer)out).write(this.renderTemplate("savetodashboardform.vm", context));
        }
        catch (IOException e) {
            log.error("Error rendering save to dashboard form.", (Throwable)e);
            return Response.serverError().entity((Object)this.authenticationContext.getI18nHelper().getText("gadget.common.error.save.dashboard")).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.ok((Object)((Object)out).toString()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="/add")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addGadgetToDashboard(Gadget gadget) {
        Assertions.notNull((String)"gadget", (Object)gadget);
        ApplicationUser remoteUser = this.authenticationContext.getUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(remoteUser);
        Long filterId = gadget.getFilterId();
        if (filterId == null) {
            SearchRequest searchRequest;
            String filterName = StringUtils.trim((String)gadget.getFilterName());
            if (StringUtils.isNotBlank((String)gadget.getJql())) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(remoteUser, gadget.getJql());
                searchRequest = new SearchRequest(parseResult.getQuery(), remoteUser, filterName, "");
            } else {
                searchRequest = new SearchRequest((Query)new QueryImpl(null, (OrderBy)new OrderByImpl(new SearchSort[0]), null), remoteUser, filterName, "");
            }
            this.searchRequestService.validateFilterForCreate((JiraServiceContext)context, searchRequest);
            if (context.getErrorCollection().hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.convertErrorCollectionToJson(context.getErrorCollection())).cacheControl(CacheControl.NO_CACHE).build();
            }
            SearchRequest request = this.searchRequestService.createFilter((JiraServiceContext)context, searchRequest);
            filterId = request.getId();
            VelocityRequestSession session = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getSession();
            this.sessionSearchObjectManagerFactory.createSearchRequestManager(session).setCurrentObject((Object)request);
        }
        URI gadgetUri = gadget.getGadgetUri();
        Map<String, String> userPrefMap = gadget.getUserPrefs();
        userPrefMap.put(PREF_PROJECT_OR_FILTER_ID, FILTER_PREFIX + filterId);
        userPrefMap.put(PREF_FILTER_ID, filterId.toString());
        userPrefMap.put(PREF_IS_CONFIGURED, Boolean.TRUE.toString());
        GadgetState newGadget = GadgetState.gadget((GadgetState)this.gadgetStateFactory.createGadgetState(new OpenSocialDashboardItemModuleId(gadgetUri))).userPrefs(userPrefMap).build();
        return this.addGadgetToDashboard(newGadget, gadget.getPortalId());
    }

    private Response addGadgetToDashboard(GadgetState newGadget, Long portalId) {
        DashboardState dashboard;
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        String remoteUsername = this.authenticationContext.getUser() == null ? null : this.authenticationContext.getUser().getName();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (portalId == null && (portalId = this.createDefaultDashboardClone()) == null) {
            errors.addErrorMessage(i18nHelper.getText("portletSearchRequestView.error.creating.dashboard.clone"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.convertErrorCollectionToJson((ErrorCollection)errors)).cacheControl(CacheControl.NO_CACHE).build();
        }
        try {
            dashboard = this.dashboardService.get(DashboardId.valueOf((String)portalId.toString()), remoteUsername);
        }
        catch (PermissionException e) {
            errors.addErrorMessage(i18nHelper.getText("portletSearchRequestView.dashboard.no.permission.view", (Object)portalId));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.convertErrorCollectionToJson((ErrorCollection)errors)).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (dashboard != null) {
            try {
                DashboardState updatedDashboard = dashboard.prependGadgetToColumn(newGadget, DashboardState.ColumnIndex.ZERO);
                this.dashboardService.save(updatedDashboard, remoteUsername);
                String contextPath = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
                return Response.ok((Object)(contextPath + "/secure/Dashboard.jspa?selectPageId=" + updatedDashboard.getId())).cacheControl(CacheControl.NO_CACHE).build();
            }
            catch (PermissionException e) {
                errors.addErrorMessage(i18nHelper.getText("portletSearchRequestView.dashboard.no.permission", (Object)portalId));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.convertErrorCollectionToJson((ErrorCollection)errors)).cacheControl(CacheControl.NO_CACHE).build();
            }
        }
        errors.addErrorMessage(i18nHelper.getText("portletSearchRequestView.dashboard.not.found", (Object)portalId));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.convertErrorCollectionToJson((ErrorCollection)errors)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private Long createDefaultDashboardClone() {
        PortalPage newPage;
        JiraServiceContextImpl serviceContext;
        PortalPage systemDefaultPage = this.portalPageService.getSystemDefaultPortalPage();
        Long systemDefaultId = systemDefaultPage.getId();
        String fullName = "";
        ApplicationUser user = this.authenticationContext.getUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (user != null) {
            fullName = this.userUtil.getDisplayableNameSafely(user);
            fullName = fullName == null ? "" : fullName;
        }
        String name = i18nHelper.getText("configureportal.clone.page.name", fullName);
        String desc = systemDefaultPage.getDescription();
        if (StringUtils.isBlank((String)desc)) {
            desc = i18nHelper.getText("configureportal.clone.page.desc", systemDefaultPage.getName());
        }
        if (this.portalPageService.validateForCreatePortalPageByClone((JiraServiceContext)(serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection())), newPage = PortalPage.name((String)name).description(desc).owner(user).permissions(SharedEntity.SharePermissions.PRIVATE).build(), systemDefaultId)) {
            newPage = this.portalPageService.createPortalPageByClone((JiraServiceContext)serviceContext, newPage, systemDefaultId, true);
            return newPage.getId();
        }
        return null;
    }

    private String convertErrorCollectionToJson(ErrorCollection errorCollection) {
        StringBuilder ret = new StringBuilder();
        ret.append("{generic:[");
        Collection errorMessages = errorCollection.getErrorMessages();
        Iterator it = errorMessages.iterator();
        while (it.hasNext()) {
            String errorMessage = (String)it.next();
            ret.append("\"").append(errorMessage).append("\"");
            if (!it.hasNext()) continue;
            ret.append(",");
        }
        ret.append("], fields:[");
        Map errors = errorCollection.getErrors();
        Iterator it2 = errors.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry errorEntry = it2.next();
            ret.append("{field:\"").append((String)errorEntry.getKey()).append("\",error:\"").append((String)errorEntry.getValue()).append("\"}");
            if (!it2.hasNext()) continue;
            ret.append(",");
        }
        ret.append("]}");
        return ret.toString();
    }

    private String renderTemplate(String template, Map<String, Object> velocityParams) {
        try {
            return this.templatingEngine.render(TemplateSources.file((String)(TEMPLATE_DIRECTORY_PATH + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error occurred while rendering velocity template for 'templates//" + template + "'.", (Throwable)e);
            return "";
        }
    }
}

