'use strict';

var FileViewer = module.exports = function (client) {
  this.client = client;
};

FileViewer.prototype.exists = function () {
  return this.client.isExisting('#cp-container-' + this._id);
};

FileViewer.prototype.hasErrorMessage = function () {
  return this.client.isExisting('#cp-error-message');
};

FileViewer.prototype.hasPasswordDialog = function () {
  return this.client.isExisting('#cp-preview-password');
};

FileViewer.prototype.hasOpenMinimode = function () {
  return this.client.isExisting('#cp-footer-minimode');
};

FileViewer.prototype.escape = function () {
  return this.client.keys('Escape');
};

FileViewer.prototype.arrowLeft = function () {
  return this.client.keys('Left arrow');
};

FileViewer.prototype.arrowRight = function () {
  return this.client.keys('Right arrow');
};

FileViewer.prototype.arrowUp = function () {
  return this.client.keys('Up arrow');
};

FileViewer.prototype.arrowDown = function () {
  return this.client.keys('Down arrow');
};

FileViewer.prototype.clickCloseButton = function () {
  return this.client.click('#cp-control-panel-close');
};

FileViewer.prototype.clickBackground = function () {
  return this.client.click([
    '#cp-image-preview',
    '#cp-pdf-preview',
    '#cp-video-preview',
    '#cp-error-layer'
  ].join(', '));
};

FileViewer.prototype.toggleMiniMode = function () {
  return this.client.click('#cp-files-label');
};
