'use strict';

var FileViewer = require('./file_viewer.js');

var ExamplePage = module.exports = function (client) {
  this.client = client;
  this.url = 'http://localhost:8090/examples/bare_page/index.html';
  this.fileViewer = new FileViewer(client);
};

ExamplePage.prototype.open = function () {
  return this.client.url(this.url);
};

ExamplePage.prototype.showImage = function () {
  return this.client.click('.image-link');
};

ExamplePage.prototype.showImage404 = function () {
  return this.client.click('.image-link-404');
};

ExamplePage.prototype.showDocument = function () {
  return this.client.click('.document-link');
};

ExamplePage.prototype.showDocument404 = function () {
  return this.client.click('.document-link-404');
};

ExamplePage.prototype.showDocumentPassword = function () {
  return this.client.click('.document-password-link');
};

ExamplePage.prototype.showVideoMp4 = function () {
  return this.client.click('.video-link-mp4');
};

ExamplePage.prototype.showVideoWebM = function () {
  return this.client.click('.video-link-webm');
};

ExamplePage.prototype.showVideo404 = function () {
  return this.client.click('.video-link-404');
};

ExamplePage.prototype.showAudio = function () {
  return this.client.click('.audio-link');
};

ExamplePage.prototype.showAudio404 = function () {
  return this.client.click('.audio-link-404');
};

ExamplePage.prototype.showUnsupportedFile = function () {
  return this.client.click('.unsupported-link');
};
