define('video-view/plugin-progress-tooltips', [
  'template-store-singleton',
  'jquery'
], function (
  templateStore,
  $
) {
  'use strict';

  var PluginProgressTooltips = function (options) {
    var player = this;
    var init = function () {
      $('#vjs-tip').remove();
      var tipHtml = templateStore.get('avPlayer.progressTooltip')();
      $('.vjs-progress-control').after(tipHtml);

      $('.vjs-progress-holder').on('mousemove', function (event) {
        var minutes,
          seconds,
          seekBar,
          timeInSeconds,
          mousePosition;

        seekBar = player.controlBar.progressControl.seekBar;
        mousePosition = (event.pageX - $(seekBar.el()).offset().left) / seekBar.width();
        timeInSeconds = mousePosition * player.duration();

        if (timeInSeconds === player.duration()) {
          timeInSeconds = timeInSeconds - 0.1;
        }

        minutes = Math.floor(timeInSeconds / 60);
        seconds = Math.floor(timeInSeconds - minutes * 60);

        if (seconds < 10) {
          seconds = '0' + seconds;
        }

        $('#vjs-tip-inner').text([minutes, ':', seconds].join(''));

        var $el = $('.vjs-control-bar');
        var tooltipWidth = $('#vjs-tip').outerWidth();
        var left = event.pageX - $el.offset().left - Math.round(tooltipWidth / 2);
        $('#vjs-tip').css('left', left + 'px').css('display', 'block');
      });

      $('.vjs-progress-holder, .vjs-play-control').on('mouseout', function () {
        $('#vjs-tip').css('display', 'none');
      });
    };
    this.on('loadedmetadata', init);
  };

  return PluginProgressTooltips;
});
