define('video-view/button-youtube', [
  'template-store-singleton',
  'url'
], function (
  templateStore,
  urlHelper
) {
  'use strict';

  var videojs = window.videojs;

  var ButtonYoutube = videojs.Button.extend({
    init: function (opts) {
      this._fileViewer = opts.fileViewer;
      this._player = opts.player;
      videojs.Button.call(this, this._player, {
        el: videojs.Component.prototype.createEl(null, {
          className: 'vjs-youtube-control vjs-control',
          innerHTML: templateStore.get('avPlayer.customControlBarItem')({descr: 'Youtube'}),
          role: 'button',
          tabindex: 0,
          'aria-live': 'polite'
        })
      });

      this.on('click', this.openYoutubePage);
    }
  });

  ButtonYoutube.asPlugin = function (fileViewer) {
    return function (options) {
      var player = this;
      var button = new ButtonYoutube({
        player: player,
        fileViewer: fileViewer
      });
      player.ready(function () { player.controlBar.addChild(button); });
    };
  };

  ButtonYoutube.prototype.openYoutubePage = function () {
    var srcYoutube;
    this._fileViewer.analytics.send('files.fileviewer-web.file.gotoyoutube');
    this._player.pause();
    srcYoutube = urlHelper.addQueryParamToUrl(this._player.src(), {
      start: Math.round(this._player.currentTime()),
      autoplay: 1
    });
    window.open(srcYoutube, '_blank');
  };

  return ButtonYoutube;
});
