(function () {
  /*global sinon, test, equal, ok*/
  'use strict';

  var $ = require('jquery');

  var FileViewer = require('file-viewer');
  var VideoView = require('video-view');
  var noop = function () {};

  var createFileViewerMock = function () {
      var fileViewer = new FileViewer({});
      return fileViewer;
  };

  module('VideoView');

  test('#._shouldUseHdSource() returns false with no HD source and videoDefaultQualityHd = undefined' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    fileViewer.getStorage().removeItem('videoQualityHd');
    
    // then
    equal(view._shouldUseHdSource(), false);
  });

  test('#._shouldUseHdSource() returns true with a HD source and videoDefaultQualityHd = undefined' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    view._hasHdSource = true;
    fileViewer.getStorage().removeItem('videoQualityHd');
    
    // then
    equal(view._shouldUseHdSource(), true);
  });

  test('#._shouldUseHdSource() returns false with no HD source and videoDefaultQualityHd = true' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    view._hasHdSource = false;
    fileViewer.getStorage().removeItem('videoQualityHd');
    fileViewer.getStorage().setItem('videoQualityHd', true);
    
    // then
    equal(view._shouldUseHdSource(), false);
  });

  test('#._shouldUseHdSource() returns false with no HD source and videoDefaultQualityHd = false' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    view._hasHdSource = false;
    fileViewer.getStorage().removeItem('videoQualityHd');
    fileViewer.getStorage().setItem('videoQualityHd', false);
    
    // then
    equal(view._shouldUseHdSource(), false);
  });

  test('#._shouldUseHdSource() returns true with a HD source and videoDefaultQualityHd = true' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    view._hasHdSource = true;
    fileViewer.getStorage().removeItem('videoQualityHd');
    fileViewer.getStorage().setItem('videoQualityHd', true);
    
    // then
    equal(view._shouldUseHdSource(), true);
  });

  test('#._shouldUseHdSource() returns false with a HD source and videoDefaultQualityHd = false' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function () { return ''; }
        }
    });

    // when
    view._hasHdSource = true;
    fileViewer.getStorage().removeItem('videoQualityHd');
    fileViewer.getStorage().setItem('videoQualityHd', false);
    
    // then
    equal(view._shouldUseHdSource(), false);
  });

  test('#._getPosterForCurrentQuality() returns SD poster for SD video' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var model = {
        poster: 'poster-low',
        poster_hd: 'poster-high'
    };
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function (key) {
              return model[key] || '';
            }
        }
    });

    // when
    view._shouldUseHdSource = sinon.stub().returns(false);

    // then
    equal(view._getPosterForCurrentQuality(), 'poster-low');
  });

  test('#._getPosterForCurrentQuality() returns HD poster for HD video' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var model = {
        poster: 'poster-low',
        poster_hd: 'poster-high'
    };
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function (key) {
              return model[key] || '';
            }
        }
    });

    // when
    view._shouldUseHdSource = sinon.stub().returns(true);

    // then
    equal(view._getPosterForCurrentQuality(), 'poster-high');
  });

  test('#._getPosterForCurrentQuality() returns SD poster for HD video if HD poster is missing' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var model = {
        poster: 'poster-low'
    };
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function (key) {
              return model[key] || '';
            }
        }
    });

    // when
    view._shouldUseHdSource = sinon.stub().returns(true);

    // then
    equal(view._getPosterForCurrentQuality(), 'poster-low');
  });

  test('#._getPosterForCurrentQuality() returns empty string if no posters are available' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var model = {};
    var view = new VideoView({
        fileViewer: fileViewer,
        model: {
            get: function (key) {
              return model[key] || '';
            }
        }
    });

    // when
    view._shouldUseHdSource = sinon.stub().returns(true);

    // then
    equal(view._getPosterForCurrentQuality(), '');
  });

}());
