(function () {
    'use strict';

    var FileViewer = require('file-viewer');
    var File = require('file');
    var UnknownFileTypeView = require('unknown-file-type-view');

    module('UnknownFileTypeView');

    test('it triggers an analytics event, when the call to action button is clicked', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        var viewer = new UnknownFileTypeView({fileViewer: fileViewer, model: file});
        var hasher = function (x) { return x.toUpperCase(); };

        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;

        viewer.render();
        // don't really download stuff
        viewer.$('.download-button').click(function (ev) { ev.preventDefault(); });

        // when
        viewer.$('.download-button').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.download');
        equal(data.actionType, 'cta');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());