/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Extracted from PDFJS viewer.js by Atlassian to be AMD compatible
 * and to remove unneeded features
 */
define('pdf-viewer/cache',
  [
    'pdf-viewer/viewer-properties'
  ],
  function (
    viewerProperties
    ) {
    var Cache = function cacheCache (size) {
      var data = [];
      this.push = function cachePush (view) {
        var i = data.indexOf(view);
        if (i >= 0) {
          data.splice(i, 1);
        }
        data.push(view);
        if (data.length > size) {
          data.shift().destroy();
        }
      };
      this.resize = function (newSize) {
        size = newSize;
        while (data.length > size) {
          data.shift().destroy();
        }
      };
    };

    return new Cache(viewerProperties.DEFAULT_CACHE_SIZE);
  });
