(function () {
    'use strict';

    var MockPdfViewer = function () {};
    MockPdfViewer.prototype.watchScroll = function () {};

    var createViewerMock = function ($container, $page) {
        return {
            el: { container: $container },
            pages: [{el: $page }],
            page: 0,
            setPagePadding: function (padding) {
                this._pagePadding = {
                    x: parseInt(padding.x, 10) || 0,
                    y: parseInt(padding.y, 10) || 0
                };
            }
        };
    };

    var $ = require('jquery');
    var viewerProperties = require('pdf-viewer/viewer-properties');
    var PdfView = require('pdf-view', {
        'pdf-viewer/pdf-viewer': MockPdfViewer
    });

    var showArrowMock = function (result) {
        return {
            getView: function () {
                return {
                    fileContentView: {
                        getLayerForName: function () {
                            return {
                                showsArrow: function () {
                                    return result;
                                }
                            };
                        }
                    }
                }
            }
        };
    }

    module('pdf-view');

    test('#scrollCenter() correctly sets container.scrollLeft', function () {
        // given
        var pdfView = new PdfView({});
        var $container = $('<div>').width(300);
        var $page = $('<div>').width(600);
        sinon.spy($.fn, 'scrollLeft');
        pdfView.viewer = createViewerMock($container, $page);
        
        // when
        pdfView.scrollCenter();

        // then
        equal($container.scrollLeft.args[0][0], 150);
        $.fn.scrollLeft.restore();
    });

    test('#scrollCenter() does nothing when page.width < container.width', function () {
        // given
        var pdfView = new PdfView({});
        var $container = $('<div>').width(600);
        var $page = $('<div>').width(300);
        sinon.spy($.fn, 'scrollLeft');
        pdfView.viewer = createViewerMock($container, $page);

        // when
        pdfView.scrollCenter();

        // then
        ok(!$container.scrollLeft.called);
        $.fn.scrollLeft.restore();
    });

    test('#setupMode() sets correct pagePadding for BASE mode', function () {
        // given
        var pdfView = new PdfView({});
        pdfView._fileViewer = showArrowMock(true);
        var $container = $('<div>').width(600);
        var $page = $('<div>').width(1200);
        pdfView.viewer = createViewerMock($container, $page);

        // when
        pdfView.setupMode('BASE');

        // then
        equal(pdfView.viewer._pagePadding.x, viewerProperties.NAVIGATION_ARROW_PADDING);
        equal(pdfView.viewer._pagePadding.y, viewerProperties.VERTICAL_PADDING);
    });

    test('#setupMode() sets correct pagePadding for BASE mode without arrows', function () {
        // given
        var pdfView = new PdfView({});
        pdfView._fileViewer = showArrowMock(false);
        var $container = $('<div>').width(600);
        var $page = $('<div>').width(1200);
        pdfView.viewer = createViewerMock($container, $page);

        // when
        pdfView.setupMode('BASE');

        // then
        equal(pdfView.viewer._pagePadding.x, viewerProperties.SCROLLBAR_PADDING);
        equal(pdfView.viewer._pagePadding.y, viewerProperties.VERTICAL_PADDING);
    });

    test('#setupMode() sets correct pagePadding for PRESENTATION mode', function () {
        // given
        var pdfView = new PdfView({});
        pdfView._fileViewer = showArrowMock(false);
        var $container = $('<div>').width(600);
        var $page = $('<div>').width(1200);
        pdfView.viewer = createViewerMock($container, $page);

        // when
        pdfView.setupMode('PRESENTATION');

        // then
        equal(pdfView.viewer._pagePadding.x, 0);
        equal(pdfView.viewer._pagePadding.y, 0);
    });

}());
