define('annotation-layer-builder',
  [
    'pdf-viewer/viewer-properties',
    'jquery'
  ],
  function (
    viewerProperties,
    $
    ) {
    var AnnotationLayerBuilder = function (opts) {
      this.annotations = opts.annotations;
      this._fileViewer = opts.fileViewer;
      this.PinsView = opts.PinsView;
      this.annotationLayers = [];
    };

    AnnotationLayerBuilder.prototype.create = function () {
      var that = this;

      function AnnotationLayer (options) {
        this.layerDiv = options.layerDiv;
        this.pageIdx = options.pageIndex;
        this.lastScrollSource = options.lastScrollSource || null;
        this.viewport = options.viewport;
        this.isViewerInPresentationMode = options.isViewerInPresentationMode;
        this.renderTimer = null;
        that.annotationLayers.push(this);

        this.pinsView = new that.PinsView({
          fileViewer: that._fileViewer,
          container: $(this.layerDiv),
          filter: function (annotation) {
            return annotation.get('pageNumber') === this.pageIdx + 1;
          }.bind(this),
          collection: that.annotations
        });

        this.layerDiv.className = 'annotationLayer';
      }

      AnnotationLayer.prototype = {
        render: function () {
          this.pinsView.render();
        },

        setupRenderLayoutTimer: function () {
          // Schedule renderLayout() if the user has been scrolling,
          // otherwise run it right away.
          var self = this;
          var lastScroll = (this.lastScrollSource === null ?
            0 : this.lastScrollSource.lastScroll);

          if (Date.now() - lastScroll > viewerProperties.RENDER_DELAY) { // Render right away
            this.render();
          } else { // Schedule
            if (this.renderTimer) {
              clearTimeout(this.renderTimer);
            }
            this.renderTimer = setTimeout(function () {
              self.setupRenderLayoutTimer();
            }, viewerProperties.RENDER_DELAY);
          }
        }
      };
      return AnnotationLayer;
    };

    AnnotationLayerBuilder.prototype.updateAnnotations = function (annotations) {
      this.annotations = annotations;
      this.annotationLayers.forEach(function (layer) {
        layer.render();
      });
    };

    return AnnotationLayerBuilder;
  }
);
