define('3d-view', [
  '3d-viewer/three-viewer',
  'ajs',
  'BaseViewer',
  'template-store-singleton',
  'jquery'
],
function (
  ThreeViewer,
  AJS,
  BaseViewer,
  templateStore,
  $
) {
  'use strict';

  var ThreeDView = BaseViewer.extend({

    id: 'cp-3d-view-wrapper',

    tagName: 'div',

    initialize: function () {
      BaseViewer.prototype.initialize.apply(this, arguments);
      this.viewer = new ThreeViewer();
    },

    teardown: function () {
      this.viewer.dispose();
      this.viewer = null;
      this.off();
      this.remove();
    },

    render: function () {
      this.$el.html(templateStore.get('threeDViewer')({}));
      this.viewer.init(this.$el[0], this.model.get('src'));

      var oldOnComplete = this.viewer.loader.file.onComplete.bind(this.viewer.loader);
      this.viewer.loader.file.onComplete = (function (e) {
        $('.cp-3d-spinner', this.$el).hide();
        oldOnComplete(e);
      }).bind(this);

      this.viewer.render();

      var fileView = this._fileViewer.getView();

      // kill sidebar view.
      if (fileView.fileSidebarView.isAnyPanelInitialized()) {
        fileView.fileSidebarView.teardownPanel();
      }

      this.trigger('viewerReady');

      return this;
    },

    setupMode: function (mode, isModeChanged) {
      var view  = this._fileViewer.getView();
      var toolbar = view.fileContentView.getLayerForName('toolbar');
      var oldActions = toolbar.getActions();
      toolbar.setActions(oldActions.concat(ThreeDView._CUSTOM_ACTIONS));
    },

    zoomIn: function () {
      this.viewer.zoom(1.0 + ThreeDView._ZOOM_FACTOR);
    },

    zoomOut: function () {
      this.viewer.zoom(1.0 - ThreeDView._ZOOM_FACTOR);
    },

    zoomActual: function () {
      this.viewer.zoom(1.0);
    }

  });

  ThreeDView._CUSTOM_ACTIONS = [{
    title: AJS.I18n.getText('cp.3d.file.type.toggle.grid'),
    className: 'cp-toolbar-3d-toggle-grid',
    predicate: function () {
      return true;
    },
    handler: function () {
      this._fileViewer.analytics.send('files.fileviewer-web.file.3d.disable-grid', {
        actionType: 'button'
      });
      this._viewer.viewer.toggleGrid();
    }
  }, {
    title: AJS.I18n.getText('cp.3d.file.type.toggle.camera.type'),
    className: 'cp-toolbar-3d-toggle-camera-type',
    predicate: function () {
      return true;
    },
    handler: function () {
      this._fileViewer.analytics.send('files.fileviewer-web.file.3d.toggle-camera-type', {
        actionType: 'button'
      });
      this._viewer.viewer.toggleCameraType();
    }
  }, {
    title: AJS.I18n.getText('cp.3d.file.type.toggle.axis'),
    className: 'cp-toolbar-3d-toggle-axis',
    predicate: function () {
      return true;
    },
    handler: function () {
      this._fileViewer.analytics.send('files.fileviewer-web.file.3d.toggle-axis', {
        actionType: 'button'
      });
      this._viewer.viewer.toggleAxes();
    }
  }
  ];
  ThreeDView._ZOOM_FACTOR = 0.2;

  return ThreeDView;
});
