(function () {
    'use strict';

    var ViewerRegistry = require('viewer-registry');

    module('Empty ViewerRegistry', {
        setup: function () {
            this.registry = new ViewerRegistry();
            this.stubbedPreviewer = sinon.stub();
        }
    });

    test('register', function () {
        this.registry.register('Mock', this.stubbedPreviewer, 10);
        var registeredPreviewer = this.registry._handlers[0];

        equal(this.registry._handlers.length, 1);
        equal(registeredPreviewer.matchesFileType('Mock'), true);
        equal(registeredPreviewer.previewer, this.stubbedPreviewer);
        equal(registeredPreviewer.weight, 10);
    });

    module('ViewerRegistry', {
        setup: function () {
            this.registry = new ViewerRegistry();
            this.stubbedPreviewer = sinon.stub();
            this.anotherPreviewer = sinon.stub();

            this.registry.register('Mock', this.stubbedPreviewer, 10);
            this.registry.register('Stub', this.anotherPreviewer, 20);
            this.registry.register('File', this.anotherPreviewer, 1000);
        }
    });

    test('weights are sorted correctly', function () {
        var firstRegister = this.registry._handlers[0];
        var secondRegister = this.registry._handlers[1];

        equal(this.registry._handlers.length, 3);

        equal(firstRegister.weight, 10);
        equal(firstRegister.matchesFileType('Mock'), true);
        equal(firstRegister.previewer, this.stubbedPreviewer);

        equal(secondRegister.weight, 20);
        equal(secondRegister.matchesFileType('Stub'), true);
        equal(secondRegister.previewer, this.anotherPreviewer);
    });

    test('get', function () {
        equal(this.registry.get('Mock'), this.stubbedPreviewer);
        equal(this.registry.get('File'), this.anotherPreviewer);

        // make sure get is immutable
        equal(this.registry._handlers.length, 3);
    });

}());
