define('url', [], function () {
  'use strict';
  return {
    /**
     * Adds an objects keys and values as query parameters to an given URL.
     * @param {string} [url]
     * @param {object} [param]
     * @return {string}
     */
    addQueryParamToUrl: function (url, param) {
      param = param || {};
      url = url.split('?');
      var queryArray = url[1] && url[1].split('&');
      queryArray = queryArray || [];
      Object.keys(param).forEach(function (key, val) {
        queryArray.push(key + '=' + param[key]);
      });
      if (queryArray.length === 0) {
        return url[0];
      }
      return url[0] + '?' + queryArray.join('&');
    },
    parseQueryString: function (query) {
      var parts = query.split('&');
      var params = {};
      for (var i = 0, ii = parts.length; i < ii; ++i) {
        var param = parts[i].split('=');
        var key = param[0].toLowerCase();
        var value = param.length > 1 ? param[1] : null;
        params[decodeURIComponent(key)] = decodeURIComponent(value);
      }
      return params;
    }
  };
});
