(function () {
    'use strict';

    var ModuleStore = require('module-store');

    module('ModuleStore', {
        setup: function () {
            this.moduleStore = new ModuleStore();
        }
    });

    test('validBackend() returns true for functions', function () {
        var backend = function () {};
        equal(ModuleStore.validBackend({}), false, 'object is not valid');
        equal(ModuleStore.validBackend(backend), true, 'function is valid');
    });

    test('#get() asks the registered backend for the module and gets a promise', function () {
        var module = function () {};
        var backend = sinon.stub().returns(module);

        this.moduleStore.useBackend(backend);

        var modulePromise = this.moduleStore.get('module');

        ok(modulePromise.then instanceof Function, 'returns a promise');

        ok(backend.calledOnce, 'backend called');
        equal(backend.args[0][0], 'module', 'called with module path');

        stop();
        modulePromise.then(function (resolvedModule) {
            start();
            equal(resolvedModule, module, 'returns correct module');
        });
    });

    test('#get() throws if no backend is set', function () {
        throws(function () {
            this.moduleStore.get('any');
        }.bind(this), 'no backend is set');
    });

    test('#useBackend() throws if backend is invalid', function () {
        throws(function () {
            this.moduleStore.useBackend(null);
        }.bind(this), 'null is not a backend');
    });

}());
