(function () {
  /*global sinon, test, equal, ok*/
  'use strict';

  var $ = require('jquery');
  var FocusManagerFactory = require('focus-manager-factory');
  var noop = function () {};

  module('FocusManagerFactory');

  test('#._focusManager() blurs the element if it’s not a child of the container' , function () {

    // given
    var event = {
      stopPropagation: noop,
      target: $('<div>')[0]
    };
    var $container = $('<div>');
    var fm = new FocusManagerFactory($container).create(false);

    sinon.spy($container, 'focus');
    sinon.spy(document.activeElement, 'blur');

    sinon.stub($container[0], 'contains').returns(false);

    // when
    fm._focusHandler(event);

    // then
    equal($container.attr('tabindex'), 1);
    ok($container.focus.calledOnce);
    ok(document.activeElement.blur.calledOnce);

    document.activeElement.blur.restore();

  });

  test('#._focusManager() doesn’t blur the element if it’s not a child of the container but has a `data-fv-allow-focus` attribtue' , function () {

    // given
    var event = {
      stopPropagation: noop,
      target: $('<div>').attr('data-fv-allow-focus', true)[0]
    };
    var $container = $('<div>');
    var fm = new FocusManagerFactory($container).create(false);

    sinon.spy($container, 'focus');
    sinon.spy(document.activeElement, 'blur');

    sinon.stub($container[0], 'contains').returns(false);

    // when
    fm._focusHandler(event);

    // then
    equal($container.attr('tabindex'), undefined);
    ok(!$container.focus.calledOnce);
    ok(!document.activeElement.blur.calledOnce);

    document.activeElement.blur.restore();

  });

  test('#._focusManager() doesn’t blur the element if it’s not a child of the container but a parent element has a `data-fv-allow-focus` attribtue' , function () {

    // given
    var event = {
      stopPropagation: noop,
      target: $('<form>').attr('data-fv-allow-focus', true).append($('<input>')).find('input')[0]
    };
    var $container = $('<div>');
    var fm = new FocusManagerFactory($container).create(false);

    sinon.spy($container, 'focus');
    sinon.spy(document.activeElement, 'blur');

    sinon.stub($container[0], 'contains').returns(false);

    // when
    fm._focusHandler(event);

    // then
    equal($container.attr('tabindex'), undefined);
    ok(!$container.focus.calledOnce);
    ok(!document.activeElement.blur.calledOnce);

    document.activeElement.blur.restore();

  });

  test('#._focusManager() doesn’t blur the element if it’s a child of the container' , function () {

    // given
    var event = {
      stopPropagation: noop,
      target: $('<div>')[0]
    };
    var $container = $('<div>');
    var fm = new FocusManagerFactory($container).create(false);

    sinon.spy($container, 'focus');
    sinon.spy(document.activeElement, 'blur');

    sinon.stub($container[0], 'contains').returns(true);

    // when
    fm._focusHandler(event);

    // then
    equal($container.attr('tabindex'), undefined);
    ok(!$container.focus.calledOnce);
    ok(!document.activeElement.blur.calledOnce);

    document.activeElement.blur.restore();

  });

  test('#._unfocusParentPage() stores activeElement and blurs it' , function () {

    // given
    var event = { stopPropagation: noop };
    var $container = $('<div>');
    var fm = new FocusManagerFactory($container).create(false);

    sinon.spy($container, 'focus');
    sinon.spy(document.activeElement, 'blur');

    // sinon.stub($container[0], 'contains').returns(true);

    // when
    fm._unfocusParentPage();

    // then
    equal(fm._originalActiveElement, document.activeElement);
    equal($container.attr('tabindex'), 1);
    ok(fm._originalActiveElement.blur.calledOnce);
    ok($container.focus.calledOnce);
    ok(document.activeElement.blur.calledOnce);

    document.activeElement.blur.restore();

  });

}());
