define('focus-manager-factory', ['assert', 'focus-manager-noop', 'focus-manager-impl'], function (assert, NoopFocusManager, FocusManager) {
  'use strict';

  /**
   * Transparent wrapper around FocusManager API that conditionally switches implementations.
   * @constructor
   * @param {jQuery} $el - The outmost element within focus will be trapped
   */
  var FocusManagerFactory = function ($el) {
    this.__element = $el;
  };

  FocusManagerFactory.prototype.create = function (embedded) {
    var ctor = embedded ? NoopFocusManager : FocusManager;
    return new ctor(this.__element);
  };

  return FocusManagerFactory;
});
