define('djb2', [], function () {

  var toCharCode = function (str) { return str.charCodeAt(0); };
  var updateHash = function (prev, curr) { return ((prev << 5) + prev) + curr; };

  /**
   * Create a djb2 hash from the given string.
   * Based on this module https://github.com/wearefractal/djb2.
   * @param {String} str
   * @returns {Number}
   */
  var djb2 = function (str) {
    return str.split('').map(toCharCode).reduce(updateHash, 5381);
  };

  return djb2;
});