(function () {
    'use strict';

    var ConstantsDictionary = require('constants-dictionary');

    module('ConstantsDictionary', {
        setup: function () {
            this.constantsDictionary = new ConstantsDictionary();
            this.val = {};
        },
        teardown: function () {
        }
    });

    test('#define() stores a value for the name given', function () {
        this.constantsDictionary.define('c1', this.val);
        ok(this.constantsDictionary.isDefined('c1'), 'value is stored');
    });

    test('#define() throws when calling define for an existing name', function () {
        this.constantsDictionary.define('c1', this.val);
        throws(function () {
            this.constantsDictionary.define('c1', this.val);
        }.bind(this), 'throws when redefining a constant');
    });

    test('#define() throws when redefining names with undefined value', function () {
        this.constantsDictionary.define('c1', undefined);
        throws(function () {
            this.constantsDictionary.define('c1', this.val);
        }.bind(this), 'throws when redefining a constant with undefined');
    });

    test('#lookup() returns the defined value', function () {
        this.constantsDictionary.define('c1', this.val);
        equal(this.constantsDictionary.lookup('c1'), this.val, 'values match');
    });

    test('#lookup() throws when asked to return a non-defined value', function () {
        throws(function () {
            equal(this.constantsDictionary.lookup('c1'), this.val, 'values match');
        }.bind(this), 'throws when looking up a non-defined value');
    });

    test('#isDefined() returns true after a name was defined', function () {
        equal(this.constantsDictionary.isDefined('c1'), false, 'name is not defined');
        this.constantsDictionary.define('c1', this.val);
        equal(this.constantsDictionary.isDefined('c1'), true, 'name is defined');
    });

    test('#isDefined() also works for the value undefined', function () {
        this.constantsDictionary.define('c1', undefined);
        equal(this.constantsDictionary.isDefined('c1'), true, 'name is defined');
        throws(function () {
            this.constantsDictionary.define('c1', this.val);
        }.bind(this), 'throws when redefining a constant with undefined');
    });

    test('#list() lists all registered plugins sorted by name', function () {
        this.constantsDictionary.define('c1', 1);
        this.constantsDictionary.define('c0', 0);

        var definitions = this.constantsDictionary.list();
        equal(definitions.length, 2, 'has all the elements');
        equal(definitions[0].name, 'c1', 'name for el1 is correct');
        equal(definitions[0].value, 1, 'value for el1 is correct');
        equal(definitions[1].name, 'c0', 'name for el0 is correct');
        equal(definitions[1].value, 0, 'value for el0 is correct');
    });

}());
