(function () {
    'use strict';

    var _ = require("underscore");
    var $ = require('jquery');
    var Backbone = require("backbone");
    var FileThumbnailView = require("minimode/ThumbnailView");
    var FileViewer = require("file-viewer");
    var File = require("file");
    var Files = require("files");

    module("File Thumbnail View tests", {
        setup: function() {
            this.$thumbnailPane = $("<div id='cp-thumbnails'/>").appendTo($("body"));
            this.model = new File({
                id: '21',
                src: "base/src/test/resources/image/pug200.png",
                title: "Kitten",
                thumbnail: "base/src/test/resources/image/pug50.png",
                type: "image/jpeg"
            });

            this.fileViewer = new FileViewer();

            this.view = new FileThumbnailView({
                model: this.model,
                fileViewer: this.fileViewer,
                footerView: _.extend({}, Backbone.Events),
                panelView: _.extend({}, Backbone.Events)
            });

            this.fileViewer._fileState.setCollection(new Files());

            this.view.setSelected = sinon.stub(this.view, "setSelected");
        },

        teardown: function() {
            this.view.remove();
            this.view.unbind();
            this.$thumbnailPane.remove();
        }
    });

    test("Can render the thumbnail", function() {
        expect(3);
        equal(this.view.el.tagName.toLowerCase(), "li");

        var $renderedEl = this.view.render().$el;
        $renderedEl.appendTo(this.$thumbnailPane);

        var $img = $renderedEl.find("img");
        ok($img.length === 1, "There is an image in the rendered thumbnail");
        equal($img.attr("src"), "base/src/test/resources/image/pug50.png", "Thumbnail image is used as src");
    });

    test('clicking a thumbnail triggers an analytics event', function () {
        // given
        var file = new File({ type: 'test/example', src: 'example'});
        var panelView = _.extend({}, Backbone.Events);
        var hasher = function (x) { return x.toUpperCase(); };
        var analyticsBackend = sinon.spy();
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        var thumbnailView = new FileThumbnailView({fileViewer:fileViewer, model:file, panelView:panelView});

        fileViewer.showFile = sinon.stub().returns($.when(file));
        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;

        // when
        thumbnailView.$el.click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.minimode.thumbnail.clicked');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());
