(function () {
    'use strict';

    var $ = require('jquery');
    var FileViewer = require("file-viewer");
    var File = require("file");
    var MinimodeToggle = require('minimode/MinimodeToggle');

    module("MinimodeToggle");

    test('clicking the closed panel triggers an open analytics event', function () {
        // given
        var file = new File({ type: 'test/example', src: 'example'});
        var hasher = function (x) { return x.toUpperCase(); };
        var analyticsBackend = sinon.spy();
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        var minimodeToggle = new MinimodeToggle({fileViewer:fileViewer});

        fileViewer.showFile = sinon.stub().returns($.when(file));
        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;
        fileViewer.getView().fileSinkView.isPanelInitialized = sinon.stub().returns(false);
        fileViewer.getView().fileSinkView.initializePanel = sinon.stub();

        // when
        minimodeToggle.render().$('#cp-files-label').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.minimode.opened');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

    test('clicking the opened panel triggers a close analytics event', function () {
        // given
        var file = new File({ type: 'test/example', src: 'example'});
        var hasher = function (x) { return x.toUpperCase(); };
        var analyticsBackend = sinon.spy();
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        var minimodeToggle = new MinimodeToggle({fileViewer:fileViewer});

        fileViewer.showFile = sinon.stub().returns($.when(file));
        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;
        fileViewer.getView().fileSinkView.isPanelInitialized = sinon.stub().returns(true);
        fileViewer.getView().fileSinkView.teardownPanel = sinon.stub();

        // when
        minimodeToggle.render().$('#cp-files-label').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.minimode.closed');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());
