(function () {
  'use strict';

  var $ = require('jquery');
  var File = require('file');
  var Commands = require('Commands');

  module('Commands');

  test('LookupViewer.execute() resolves with viewer, previewSrc and convertedFile when successful', function () {
    var file = new File();
    var viewer = {};
    var viewerLookupFn = function () { return $.when(viewer); };
    var viewerRegistry = { get: function () { return viewerLookupFn; }};
    var cmd = new Commands.LookupViewer(file, viewerRegistry);

    cmd.execute('previewSrc', 'previewType').then(function (viewerIn, previewSrcIn, convertedFileIn) {
      equal(viewerIn, viewer);
      equal(previewSrcIn, 'previewSrc');
      ok(convertedFileIn !== file, 'uses converted file instead of real file');
    });
  });

  test('LookupViewer.execute() sets overwrites on the convertedFile it passes', function () {
    var file = new File({ src: 'normalSource' });
    var viewer = {};
    var viewerLookupFn = function () { return $.when(viewer); };
    var viewerRegistry = { get: function () { return viewerLookupFn; }};
    var cmd = new Commands.LookupViewer(file, viewerRegistry);
    var overwrites = { src_hd: 'hdSource' };

    cmd.execute('previewSrc', 'previewType', overwrites).then(function (viewerIn, previewSrcIn, convertedFile) {
      var file = convertedFile.attributes;
      equal(file.src, 'previewSrc');
      equal(file.type, 'previewType');
      equal(file.src_hd, 'hdSource');
    });
  });

  test('LookupViewer.execute() rejects with an error if the viewer registry doesn’t find a viewer', function () {
    var file = new File();
    var viewerRegistry = { get: function () { }};
    var cmd = new Commands.LookupViewer(file, viewerRegistry);

    cmd.execute('previewSrc', 'previewType').then(
      function () { throw new Error('expected failure'); },
      function (e) { ok(e instanceof Error); }
    );
  });


}());