(function () {
    'use strict';

    var $ = require('jquery');
    var keys = require('keyboard').keys;
    var FileViewer = require('file-viewer');
    var File = require('file');
    var ToolbarLayer = require('ToolbarLayer');
    var MainView = require('MainView');
    var baseMode = require('baseMode');

    var noop = function () {};
    var createFileViewer = function (analyticsBackend, hasher, file) {
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;
        return fileViewer;
    };

    module('ToolbarLayer');

    test('the zoom-in button sends an anlytics event', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };
        var fileViewer = createFileViewer(analyticsBackend, hasher, file);
        var toolbarLayer = new ToolbarLayer({fileViewer: fileViewer});

        toolbarLayer.setActions(baseMode.toolbarActions);
        toolbarLayer.render().setViewer({ zoomIn: noop });

        // when
        toolbarLayer.$('.cp-toolbar-plus').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.zoomin');
        equal(data.actionType, 'button');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

    test('zoom-in shortcut sends an anlytics event', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };
        var fileViewer = createFileViewer(analyticsBackend, hasher, file);
        var mainView = fileViewer.getView();

        fileViewer.open();
        fileViewer.showFile(file);
        mainView.fileContentView.getLayerForName('content').attachViewer({ zoomIn: noop });

        // when
        $(document).trigger({ type: 'keydown', ctrlKey: true, which: keys.PLUS});

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.zoomin');
        equal(data.actionType, 'hotkey');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

    test('the zoom-out button sends an anlytics event', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };
        var fileViewer = createFileViewer(analyticsBackend, hasher, file);
        var toolbarLayer = new ToolbarLayer({fileViewer: fileViewer});

        toolbarLayer.setActions(baseMode.toolbarActions);
        toolbarLayer.render().setViewer({ zoomOut: noop });

        // when
        toolbarLayer.$('.cp-toolbar-minus').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.zoomout');
        equal(data.actionType, 'button');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

    test('the zoom-out shortcut sends an anlytics event', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };
        var fileViewer = createFileViewer(analyticsBackend, hasher, file);
        var mainView = fileViewer.getView();

        fileViewer.open();
        fileViewer.showFile(file);
        mainView.fileContentView.getLayerForName('content').attachViewer({ zoomOut: noop });

        // when
        $(document).trigger({ type: 'keydown', ctrlKey: true, which: keys.MINUS});

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.zoomout');
        equal(data.actionType, 'hotkey');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

    test('the zoom-fit button sends an anlytics event', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };
        var fileViewer = createFileViewer(analyticsBackend, hasher, file);
        var toolbarLayer = new ToolbarLayer({fileViewer: fileViewer});

        toolbarLayer.setActions(baseMode.toolbarActions);
        toolbarLayer.render().setViewer({ zoomFit: noop });

        // when
        toolbarLayer.$('.cp-toolbar-fit').click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.zoomfit');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());
