define('SpinnerLayer', [
  'backbone', 'template-store-singleton'
], function (Backbone, templateStore) {
  'use strict';

  // Spinner rendering
  var SPINNER_SIZE = 'large';
  var SPINNER_STYLE = {
    color: '#fff',
    zIndex: 'auto'
  };

  /**
   * Loading spinner in the middle of the file content.
   * @constructor
   */
  var SpinnerLayer = Backbone.View.extend({

    className: 'cp-spinner-layer',

    initialize: function () {
      this._updateElements();
    },

    render: function () {
      this.$el.html(templateStore.get('fileBodySpinner')());
      this._updateElements();
      return this;
    },

    /**
     * Instruct the spinner to start.
     */
    startSpin: function () {
      this.$spinner.spin(SPINNER_SIZE, SPINNER_STYLE);
    },

    /**
     * Instruct the spinner to stop.
     */
    stopSpin: function () {
      this.$spinner.spin(false);
    },

    _updateElements: function () {
      this.$spinner = this.$el.find('.cp-spinner');
    }

  });

  return SpinnerLayer;
});