define('ErrorLayer', [
  'ajs', 'backbone', 'template-store-singleton'
], function (AJS, Backbone, templateStore) {
  'use strict';

  var ErrorLayer = Backbone.View.extend({

    className: 'cp-error-layer',

    initialize: function () {
      this.$el.hide();
    },

    showErrorMessage: function (err, file) {
      var title, description, icon, srcDownload, srcBrowser;
      title = err.title || AJS.I18n.getText('cp.error.default.header');
      description = err.description || err.toString();
      icon = err.icon || false;
      srcBrowser = err.browser ? file.get('src') : false;
      srcDownload = err.download ? file.get('srcDownload') || file.get('src') : false;
      this.$el.show().html(templateStore.get('displayError')({
        title: title,
        message: description,
        icon: icon,
        srcBrowser: srcBrowser,
        srcDownload: srcDownload
      }));
    }

  });

  return ErrorLayer;
});
