(function () {
    'use strict';

    var Backbone = require('backbone');
    var File = require('file');
    var Files = require('files');
    var FileState = require('file-state');

    module('fileState', {
        setup: function () {
            this.fileState = new FileState();
            this.fileState.setCollection(new Files());
        },
        teardown: function () {
            this.fileState.collection.reset();
            this.fileState.collection = null;
        }
    });

    test('#selectWhere() sets the current file according to the query', function () {
        var file1 = new File({ id: 1 }), file2 = new File({ id: 2 });

        this.fileState.collection.add(file1);
        this.fileState.collection.add(file2);

        this.fileState.selectWhere({ id: 2 });

        equal(this.fileState.getCurrent(), file2, 'the selected item is returned');
    });

    test('#selectWhere() sets the current file to the first one added if no query is given', function () {
        var file1 = new File({ id: 1 }), file2 = new File({ id: 2 });

        this.fileState.collection.add(file1);
        this.fileState.collection.add(file2);

        this.fileState.selectWhere({ id: 2 });

        equal(this.fileState.getCurrent(), file2, 'the selected item is returned');

        this.fileState.selectWhere();
        equal(this.fileState.getCurrent(), file1, 'the selected item is reset');

    });

    test('#selectWhere() does not change the current if there is no file and no selector is given', function () {
        this.fileState.selectWhere();
        equal(this.fileState.getCurrent(), null, 'no item is selected without selector');
    });

    test('#selectWhere() does not throw if there is no file and a selector is given', function () {
        this.fileState.selectWhere({ id: 2 });
        equal(this.fileState.getCurrent(), null, 'no item is selected without selector');
    });

}());
